//to compile:    g++ -o timed_v2.0 timed_v2.0.cpp -lipq
extern "C" {
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <libipq.h> //if you are on Ubuntu 8.04 LTS change libipq.h in libipq/libipq.h
#include <linux/netfilter.h>
#include <linux/ip.h>  //added to read transport protocol by iphdr stuct
}


#include <iostream>
#include <cstddef>
#include <cassert>

#include <sys/time.h>
#include <time.h>
#include <signal.h>
#include <stdio.h>
#include <stdlib.h>
#include <vector>
#include <string.h>
#include <unistd.h>
#include <math.h>

#define BUFSIZE 2048

#ifndef IPPROTO_DCCP	//if DCCP protocol is not defined in netinet/in.h define it here
#define IPPROTO_DCCP 33
#endif



static void die(struct ipq_handle *h)
{
    ipq_perror("passer");                   //Termination Function.
    ipq_destroy_handle(h);                  //Used in case of error.
    exit(1);
}


struct timeval diff_time(struct timeval tv1,struct timeval tv2)     //Elapsed Time Function
{
  struct timeval time_diff;
  if (tv1.tv_usec > tv2.tv_usec)                                    //Realize the difference
        {                                                           //between two timeval structures.
            tv2.tv_usec += 1000000;
            tv2.tv_sec--;
        }
        time_diff.tv_usec = tv2.tv_usec - tv1.tv_usec;
        time_diff.tv_sec = tv2.tv_sec - tv1.tv_sec;
        return time_diff;
}



struct timeval count_down(struct timeval tv1,struct timeval tv2)     //Timer Function
{
    struct timeval time_diff;
    time_diff.tv_sec=tv2.tv_sec-tv1.tv_sec;                    //tv2=time_total tv1=time_elapsed
    time_diff.tv_usec = tv2.tv_usec - tv1.tv_usec;
    if(time_diff.tv_usec<=0 && time_diff.tv_sec > 0)
    {
        time_diff.tv_sec--;
        time_diff.tv_usec += 1000000;
    }
    else if(time_diff.tv_usec<=0 && time_diff.tv_sec <= 0)
    {
        time_diff.tv_sec=0;
    }
    return time_diff;

}



void check_transport_protocol(ipq_packet_msg_t *m,bool &udp,bool &tcp,bool &dccp,bool &sctp)
{
	unsigned char *ip_header_pointer = NULL;
	struct iphdr* iph;
	ip_header_pointer = m->payload;
	iph = (struct iphdr*) ip_header_pointer;
	switch(iph->protocol)
		{
		case IPPROTO_UDP:
		udp=true;
		fprintf(stderr,"Protocol type: UDP\n");
		break;

		case IPPROTO_TCP:
		tcp=true;
		fprintf(stderr,"Protocol type: TCP\n");
		break;

		case IPPROTO_DCCP:
		dccp=true;
		fprintf(stderr,"Protocol type: DCCP\n");
		break;

		case IPPROTO_SCTP:
		sctp=true;
		fprintf(stderr,"Protocol type: SCTCP\n");
		break;

		default:
		fprintf(stderr, "Unknown transport protocol type!\n");
		break;
		}
}

int get_q_length()     //function that read /proc/net/ip_queue
{

FILE *file_ip_queue;
FILE *tmp_file;

file_ip_queue = fopen("/proc/net/ip_queue","r");
tmp_file = fopen("/tmp/tmp_file","w+r");

int n=1;
int qlength;

char string_ql[50];
char string_ql_tmp[50];
if (file_ip_queue == NULL) perror ("Error opening file /proc/net/ip_queue");
   else {
    while ( n!=5)
      	       {
		fgets (string_ql , 50 , file_ip_queue);
		if (n==4) fputs(string_ql,tmp_file);
		n++;
	        }
		fseek ( tmp_file , 20 , SEEK_SET );
		fgets (string_ql_tmp , 50 , tmp_file);
		qlength=atoi (string_ql_tmp);
		fclose(tmp_file);
                fclose(file_ip_queue);
	}


       return qlength;
}

void send_reason(int i,int count,int status,struct timeval time_total)
{
		if (i == count)
		fprintf(stderr,"send reason: full block\n");
		else
		{
		fprintf(stderr,"send reason: timeout\nThe ip_queue length is: %d\n",get_q_length());
		}	      
}



void send(int block_size,int int_depth,const struct ipq_handle *h,std::vector< ipq_packet_msg_t *>& queue,int index,int &count_tot_pkt)
{
    int i=0;
    int elem=0;

    while(i < block_size)                               //Interleaving logic
        {
        int j=0;
        while(j < int_depth)
            {
             elem=i+(j*block_size);

             if(elem < index){                          //It skips out the verdict on the empty locations
			ipq_set_verdict(h, queue[elem]->packet_id,NF_ACCEPT, 0, NULL);
			count_tot_pkt++; 		//total number of sent packet
             		     }
             j++;
            }
        i++;
        }
}

double rate_cless(int i,int count,struct timeval time_total,int timeout_sec,int timeout_usec) //function that calculate the rate with connectionless protocols
	{

	double actual_rate;
	struct timeval int2tv;    
	int2tv.tv_sec=timeout_sec;
	int2tv.tv_usec=timeout_usec;
	

		if (i==count)
		{
		struct timeval fblock_time;
		fblock_time=diff_time(time_total,int2tv);   //time for fill a full block
		actual_rate=((double)i/((fblock_time.tv_sec*1000000)+fblock_time.tv_usec))*1000000;
		fprintf(stderr,"we are in rate_calc() function with i==count:\nfblock_time.tv_sec = %d  fblock_time.tv_usec = %d\n",fblock_time.tv_sec,fblock_time.tv_usec);
		}
		else 
		{
		actual_rate=((double)i/((timeout_sec*1000000)+timeout_usec))*1000000;
		fprintf(stderr,"we are in rate_calc() function with expired timeout:\ntimeout_sec = %d  timeout_usec = %d\n",timeout_sec,timeout_usec);
		}

		return actual_rate;
        }


void adjust_timeout(int &timeout_sec,int &timeout_usec,double rate_old,double current_rate,double rate_max,int default_timeout_sec,int default_timeout_usec) //function that modify timeout dynamically
	{
		if (current_rate<=rate_max)
		{
			double perc_current_rate=(100*current_rate)/rate_old;  //the amount (in percent) of current rate related to rate_old
			double all_time_usec=(double)((timeout_sec*1000000)+timeout_usec); //transforming all time in microseconds

			if(current_rate > rate_old)   //if there is a rate increment we increment the timeout
			{
				double inc_perc_rate=perc_current_rate-100; //the increment (in percent) of current rate
				fprintf(stderr,"in function adjust_timeout() the precentage rate increase is %f  \n",inc_perc_rate);
				all_time_usec=all_time_usec+(all_time_usec*inc_perc_rate/100); //increment timeout in according to the percent increment of rate
				int int_all_time_usec=round(all_time_usec); //transform timeout from double to integer
				fprintf(stderr,"increased timeout in microsecond %d \n",int_all_time_usec);
				if (int_all_time_usec>5000000) int_all_time_usec=5000000; //if timeout is bigger than 5 seconds, set it to 5 seconds
				timeout_sec=int_all_time_usec/1000000;
				timeout_usec=int_all_time_usec%1000000;
					if (timeout_usec>1000000)
		 			{
					timeout_sec++;
					timeout_usec=timeout_usec-1000000;
					}
			}
	
			if( current_rate < rate_old )   //if there is a rate decrement we decrement the timeout
			{
				double dec_perc_rate=100-perc_current_rate;
				fprintf(stderr,"in function adjust_timeout() the precentage rate decrease is %f  \n",dec_perc_rate);
				all_time_usec=all_time_usec-(all_time_usec*dec_perc_rate/100);
				int int_all_time_usec=round(all_time_usec);
				fprintf(stderr,"decreased timeout in microsecond %d \n",int_all_time_usec);
				if (int_all_time_usec<((default_timeout_sec*1000000)+default_timeout_usec))   //if decremented timeout became minus of default timeout (initial timeout) set it to default timeout
				{
					timeout_sec=default_timeout_sec;
					timeout_usec=default_timeout_usec;
				}
				else
				{
					timeout_sec=int_all_time_usec/1000000;
					timeout_usec=int_all_time_usec%1000000;
						if (timeout_sec>0 && timeout_usec <= 0)
						{
						timeout_usec+=1000000;
						timeout_sec--;
						}
			 			else if(timeout_usec<=0 && timeout_sec <= 0)  //if decremented timeout became negative, set it to default timeout
    						{
        					timeout_sec=default_timeout_sec;
        					timeout_usec=default_timeout_usec;
    						}
				}
			}
		}
		else   //if current rate is bigger than maximum possible rate, set timeout to 5 second
		{
		timeout_sec=5;
		timeout_usec=0;
		}
fprintf(stderr,"Before exit from adjust_timeout() we have: timeout_sec %d timeout_usec %d",timeout_sec,timeout_usec);	
	}





double standard_deviation(double rate_array[],int k) //calculate standard deviation of varius rate
	{

		double sum=0;
		for (int j=0;j<k;j++)
		{
		sum=sum+rate_array[j];   //sum of all rates
		}
		fprintf(stderr,"\nin standard_deviation() the sum of all rates is %f\n",sum);
		double avrg;
		avrg=sum/(double)k;   //mean of all rates
		fprintf(stderr,"in standard_deviation() the average of all rate is %f\n",avrg);

		double dev=0;
		for (int j=0;j<k;j++)
		{
		dev=dev+pow((rate_array[j]-avrg),2);  //sum of simple deviations
		fprintf(stderr,"rate_array[%d]: %f\n",j,rate_array[j]); //print the array that contain rates 
		}	

		double std_dev=sqrt(dev/k);   //standard deviation
		fprintf(stderr,"stdandard deviation: %f\n",std_dev); //print standard deviation

		double rate=avrg-std_dev;  //subtract from the average of rates the standard deviation and assign it to rate

		return rate;
	}


int main(int argc, char **argv)
{
    int c;
    int int_depth;                      //Block Dimension
    int block_size;


    if (argc==1)
    {
	fprintf (stderr,"*** Block Dimension 1x1 ***\n");
        int_depth=1;                      
        block_size=1;
    }


    int count_tot_pkt=0;


if (argc==5)
{
    while ((c=getopt(argc,argv,"n:m:")) != -1)
 	{
                switch (c)  {
                        case 'n':

                                int_depth=atoi(optarg);
                                break;

                        case 'm':
                                block_size=atoi(optarg);
				break;

                        default:
                                fprintf (stderr,"*** Error: Try to insert the right dimension ***\n");
                                return 1;
                                break;
                }

        }
}
else if ( (argc>1 && argc<5) || argc > 5)
{
 fprintf (stderr,"*** Error: See usage below ***\n\nUSAGE:\n\n\t\ttimed [-n X -m Y]\n\n\t-n is matrix depth\n\t-m is matrix length\n\n\nIf you launch timed without any parameter the matrix will be 1x1.\nIf you specify the -n parameter you must also specific -m parameter so the matrix will be XxY\n");
return 1;
}

fprintf(stderr,"n: %d  m: %d\n",int_depth,block_size); //print the matrix dimension that will be used
    int status;
    int count = (int_depth*block_size);     //Temporary Indexes

    int timeout_sec;
    int timeout_usec;
    int default_timeout_sec;
    int default_timeout_usec;
    double initial_rate;
    double initial_double_timeout;
    double rate_max;


    int i = 0;
    int pushed_packets=0;
    
    std::vector< ipq_packet_msg_t *> queue;         //Temporarelly Array for to ordering

    struct ipq_handle *h;

    bool flag = true;

    struct timeval tv1,tv2,time_elapsed,first_pkt_pushed,last_pkt_pushed,time_rate;


    double rate_old;
    double current_rate;    
    double rate_coriented;
    bool first_rate=true;
    bool udp=false;
    bool tcp=false;
    bool dccp=false;
    bool sctp=false;
    int req_pkt4rate=count;
    double rate_array[req_pkt4rate];
    int k=0;

    struct timeval time_total;                  //Block Timer

    int time_read = 0;

    unsigned char buf[count][BUFSIZE];

    h = ipq_create_handle(0, PF_INET);




   //setting the size buffer of socket
    int sizesock=8388608;
    int setsock_response;
    setsock_response = setsockopt( h->fd,SOL_SOCKET, SO_RCVBUFFORCE, &sizesock, sizeof( sizesock));
    if (setsock_response < 0)
    {
    fprintf (stderr,"Setsockopt() error!!!\n");
    fprintf(stderr,"Error: %s\n", strerror( errno ) );
    return -1;
    }


    if (!h)
        die(h);

    status = ipq_set_mode(h, IPQ_COPY_PACKET, BUFSIZE);     //Copy Mode

    if (status < 0)
        die(h);

    do{
        if (i==0)
     	fprintf(stderr,"\n#####################STARTING NEW BLOCK##########################\n");
	
	fprintf(stderr,"+++++++NEW PACKET+++++++\n");

	fprintf(stderr,"The ip_queue length is: %d\n",get_q_length());



        if(flag == true)  
	{
	gettimeofday(&tv1, NULL);       //take the time of blocking read so I'll substract it to the timeout
        status = ipq_read(h, buf[i], BUFSIZE,0);
	gettimeofday(&tv2, NULL);
        }
        else {
        gettimeofday(&tv1, NULL);      //First read has a blocking behavior the next in line instead not.
	status = ipq_read(h, buf[i], BUFSIZE,time_read);
	gettimeofday(&tv2, NULL);
	fprintf(stderr,"tv1_sec %d tv1_usec %d\n",tv1.tv_sec,tv1.tv_usec); //print the timestamp of first and last packet arrived in the block
	fprintf(stderr,"tv2_sec %d tv2_usec %d\n",tv2.tv_sec,tv2.tv_usec);
        }


	if (pushed_packets>req_pkt4rate) //do it only if the intial rate and initial timeout was previously calculated
	{
        time_elapsed=diff_time(tv1,tv2);
	fprintf(stderr,"time_elapsed.tv_sec  %d time_elapsed.tv_usec  %d\n",time_elapsed.tv_sec,time_elapsed.tv_usec);//print the time elapsed to read a packet
        time_total=count_down(time_elapsed,time_total);
        time_read=(time_total.tv_sec*1000000) + time_total.tv_usec;
	fprintf(stderr,"the updated time_read from count_down() function is %d\n",time_read); //print the new time_read that will be passed to ipq_read()
        }

	if (status < 0)
            die(h);

       if(status == 0)                       //It modifies the indexes
       i--;                                  //in case of timeout.


        switch (ipq_message_type(buf[i]))                             //It switchs if we have an error or a data packet.
	{	
            case NLMSG_ERROR:
                fprintf(stderr, "Received error message %d\n",ipq_get_msgerr(buf[i]));
                break;
            case IPQM_PACKET: 
		{
                	if(status != 0)
			{
	                ipq_packet_msg_t *m = ipq_get_packet(buf[i]);
	               	queue.push_back(m);                              //Saving in a temporary queue.
			pushed_packets++; //counter of pushed packets in the first block

				if(pushed_packets==1)
				{			
				gettimeofday(&first_pkt_pushed,NULL);//take the timestamp of first packet pushed in the queue as a time reference to calculate the rate
				fprintf(stderr,"first_pkt_pushed.tv_sec %d first_pkt_pushed.tv_usec %d\n",first_pkt_pushed.tv_sec,first_pkt_pushed.tv_usec); // print timestamp of first packet pushed
				check_transport_protocol(m,udp,tcp,dccp,sctp); //check the protocol type
				}

				if(pushed_packets==3 && tcp) //if protocol is tcp I will take the third packet timestamp as a time reference to calculate the rate, so I discarded the SYN and SYN/ACK packet that increase the rate
				{			
				gettimeofday(&first_pkt_pushed,NULL);
				fprintf(stderr,"updated first_pkt_pushed.tv_sec %d updated first_pkt_pushed.tv_usec %d\n",first_pkt_pushed.tv_sec,first_pkt_pushed.tv_usec);
				}


				if(pushed_packets==5 && (dccp||sctp)) //if protocol is dccp I will take the fifth packet timestamp as a time reference to calculate the rate, so I discarded the packets of handshake that increase the rate, and the same reason is given for sctp
				{			
				gettimeofday(&first_pkt_pushed,NULL);
				fprintf(stderr,"updated first_pkt_pushed.tv_sec %d updated first_pkt_pushed.tv_usec %d\n",first_pkt_pushed.tv_sec,first_pkt_pushed.tv_usec);
				}

	/*			if( (udp && (pushed_packets>1 && pushed_packets<=req_pkt4rate)) || (tcp && (pushed_packets>3 && pushed_packets<=req_pkt4rate)) || ( (dccp||sctp) && (pushed_packets>5 && pushed_packets<=req_pkt4rate) ) )*/
				if( (udp && pushed_packets>1 && pushed_packets<=req_pkt4rate) || (tcp && pushed_packets>3 ) || ( (dccp||sctp) && pushed_packets>5 ) )
				{
				gettimeofday(&last_pkt_pushed,NULL);//take the timestamp of last packet pushed in the queue
				fprintf(stderr,"last_pkt_pushed.tv_sec %d last_pkt_pushed.tv_usec %d\n",last_pkt_pushed.tv_sec,last_pkt_pushed.tv_usec);
				}
	
			}			
                	i++;

			if (!udp && !tcp && !dccp && !sctp)  //stop the execution if the level protocol is unknow
			{
			fprintf(stderr,"Stop\n");
			return -1;
			}			
			else
			{		
				if (pushed_packets<=req_pkt4rate)
				{
				fprintf(stderr,"pushed_packets in the first block %d\n",pushed_packets); 
					
 					if (udp && (pushed_packets>1 && pushed_packets<=req_pkt4rate) )
					{
					time_rate=diff_time(first_pkt_pushed,last_pkt_pushed);
					fprintf(stderr,"time_rate.tv_sec %d time_rate.tv_usec %d\n",time_rate.tv_sec,time_rate.tv_usec);
					rate_array[k]=(((double)pushed_packets/((time_rate.tv_sec*1000000)+time_rate.tv_usec))*1000000);
					k++;
					}

					if ( tcp  && (pushed_packets>3 && pushed_packets<=req_pkt4rate) )  
					{
					time_rate=diff_time(first_pkt_pushed,last_pkt_pushed);
					fprintf(stderr,"time_rate.tv_sec %d time_rate.tv_usec %d\n",time_rate.tv_sec,time_rate.tv_usec);
					rate_array[k]=(((double)pushed_packets/((time_rate.tv_sec*1000000)+time_rate.tv_usec))*1000000);
					k++;
fprintf(stderr,"k++ %d",k);
					}

					if ( (dccp ||sctp) && (pushed_packets>5 && pushed_packets<=req_pkt4rate) )  
					{
					time_rate=diff_time(first_pkt_pushed,last_pkt_pushed);
					fprintf(stderr,"time_rate.tv_sec %d time_rate.tv_usec %d\n",time_rate.tv_sec,time_rate.tv_usec);
					rate_array[k]=(((double)pushed_packets/((time_rate.tv_sec*1000000)+time_rate.tv_usec))*1000000);
					k++;
					}
								
					
					if (pushed_packets==req_pkt4rate) //now we can calculate the initial rate and initial timeout
					{	
					initial_rate=standard_deviation(rate_array,k);
					fprintf(stderr,"initial_rate %f\n",initial_rate);

					rate_old=initial_rate;

					initial_double_timeout=count/initial_rate;
					
					time_total.tv_sec=(int)initial_double_timeout;
					time_total.tv_usec=(int)((initial_double_timeout-(int)(initial_double_timeout))*1000000);
					
	 				rate_max=((double)count/(time_total.tv_sec*1000000+time_total.tv_usec))*1000000;   
	    				fprintf(stderr,"rate_max %f\n",rate_max);

	    				default_timeout_sec=time_total.tv_sec;
				        default_timeout_usec=time_total.tv_usec;

					timeout_sec=time_total.tv_sec;
					timeout_usec=time_total.tv_usec;
					fprintf(stderr,"initial timeout_sec %d initial timeout_usec %d\n",timeout_sec,timeout_usec);
					}

				send(block_size,int_depth,h,queue,i,count_tot_pkt);
				fprintf(stderr,"send reason: we are in the first block so we use 1x1 matrix dimension\n");				
				queue.clear();
				i=0;
				}

				if (!udp && pushed_packets>req_pkt4rate)
				{
				time_rate=diff_time(first_pkt_pushed,last_pkt_pushed);
				fprintf(stderr,"time_rate.tv_sec %d time_rate.tv_usec %d\n",time_rate.tv_sec,time_rate.tv_usec);
				int j;
				if (tcp) j=req_pkt4rate-2;  //discard SYN e SYN/ACK
				if (dccp||sctp) j=req_pkt4rate-5;
				
					for (int z=0; z<j; z++) 
					{
						if (z!=(j-1))
						{
						rate_array[z]=rate_array[z+1];
						//fprintf(stderr,"\nsliding_array[%d]: %f",z,rate_array[z]);
						}
						else
						{
						rate_array[z]=(((double)pushed_packets/((time_rate.tv_sec*1000000)+time_rate.tv_usec))*1000000);
						//fprintf(stderr,"\nsliding_array[%d]: %f",z,rate_array[z]);
						}					
					}
				rate_coriented=standard_deviation(rate_array,k);
				fprintf(stderr,"rate_coriented: %f\n",rate_coriented);
				}




				if (pushed_packets>req_pkt4rate)      //we reset the flag if we have already calculated the initial timeout
		                flag = false;                                   //We are after the first packet of block.
	
		                if(pushed_packets>req_pkt4rate && (i == count  || (time_total.tv_sec<=0 && time_total.tv_usec<=0)))        //if we have already calculated the timeout, we check for full block or out of time.
		                {

		                    	flag = true;                            //Flag reset because we are going to start a new block.

					send_reason(i,count,status,time_total); //print the send reason (full block or out of time)
	
				  	send(block_size,int_depth,h,queue,i,count_tot_pkt);
					fprintf(stderr,"count_tot_pkt send %d\n",count_tot_pkt); //print the number of packet sent
	
					if (udp)
				   	current_rate=rate_cless(i,count,time_total,timeout_sec,timeout_usec);
					else
					current_rate=rate_coriented;

					fprintf(stderr,"current_rate = %f rate_old = %f   i=%d\n",current_rate,rate_old,i);
					if(!first_rate) //if we have the current rate and the old rate we can modify the timeout,because in the adjust_timeout function we compare the current rate with the old rate
					{
		   			adjust_timeout(timeout_sec,timeout_usec,rate_old,current_rate,rate_max,default_timeout_sec,default_timeout_usec);
					}
					first_rate=true;
	
					rate_old=current_rate;
	
		                        queue.clear();
		                        time_total.tv_sec=timeout_sec;          //Timer and queue reset
		                        time_total.tv_usec=timeout_usec;
	
		                    	i = 0;
		                }

	                	if (status < 0)
	                    	die(h);
	                	break;
			}                
		}

            default:
                fprintf(stderr, "Unknown message type!\n");
                break;
         }
      } while (1);
        
	ipq_destroy_handle(h);
        return 0;
}
