/*
 *   TimeD ALPHA Version (http://www.grid.unina.it/Traffic)
 *
 *   Copyright    : (C) 2009 by        Alessio Botta, Alberto Dainotti, Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and 
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *   email        : a.botta@unina.it , alberto@unina.it, pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 * 		     
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *				     
 */

#include "TimeD.h"

static void die(struct ipq_handle *h)
{
    ipq_perror("passer");                   //Termination Function.
    ipq_destroy_handle(h);                  //Used in case of error.
    exit(1);
}


struct timeval diff_time(struct timeval tv1,struct timeval tv2)     //Elapsed Time Function
{
  struct timeval time_diff;
  if (tv1.tv_usec > tv2.tv_usec)                                    //Take the difference
        {                                                           //between two timeval structures.
            tv2.tv_usec += 1000000;
            tv2.tv_sec--;
        }
        time_diff.tv_usec = tv2.tv_usec - tv1.tv_usec;
        time_diff.tv_sec = tv2.tv_sec - tv1.tv_sec;
        return time_diff;
}

struct timeval count_down(struct timeval tv1,struct timeval tv2)     //Timer Function
{
    struct timeval time_diff;
    time_diff.tv_sec=tv2.tv_sec;
    time_diff.tv_usec = tv2.tv_usec - tv1.tv_usec;
    if(time_diff.tv_usec<=0 && time_diff.tv_sec > 0)
    {
        time_diff.tv_sec--;
        time_diff.tv_usec += 1000000;
    }
    else if(time_diff.tv_usec<=0 && time_diff.tv_sec <= 0)
    {
        time_diff.tv_sec=0;
        //time_diff.tv_usec=0;
    }
    return time_diff;

}

void send(int block_size,int int_depth,const struct ipq_handle *h,std::vector< ipq_packet_msg_t *>& queue,int index)
{
    int i=0;
    int elem=0;

    while(i < block_size)                               //Interleaving logic
        {
        int j=0;
        while(j < int_depth)
            {
             elem=i+(j*block_size);
             if(elem < index){                          //Skips the verdict on the empty locations
             ipq_set_verdict(h, queue[elem]->packet_id,NF_ACCEPT, 0, NULL);
             }
             j++;
            }
        i++;
        }

}


int main(int argc, char **argv)
{
    if (argc<2)
    {
        fprintf (stderr,"*** Insert Block Dimension ***\n");
        return 1;
    }
    int c;
    int int_depth=3;                      //Block Dimension
    int block_size=4;
    int timeout_sec=20;                    //Timeout values
    int timeout_usec=0;

    while ((c=getopt(argc,argv,"n:m:s:u:")) != -1)  {
                switch (c)  {
                        case 'n':
                                int_depth=atoi(optarg);
                                break;

                        case 'm':
                                block_size=atoi(optarg);
                                break;

                        case 's':
                                timeout_sec=atoi(optarg);
                                break;

                        case 'u':
                                timeout_usec=atoi(optarg);
                                break;

                        default:
                                fprintf (stderr,"*** Error: Try to insert the right dimension ***\n");
                                return 1;
                                break;
                }
        }

    int status;
    int count = (int_depth*block_size);     //Temporary Indexes
    int i = 0;


    std::vector< ipq_packet_msg_t *> queue;         //Temporary array for ordering

    struct ipq_handle *h;

    bool flag = true;

    struct timeval tv1,tv2,time_elapsed;
    struct timeval time_total;                  //Block Timer
    time_total.tv_sec=timeout_sec;
    time_total.tv_usec=timeout_usec;
    int time_read = 0;

    unsigned char buf[count][BUFSIZE];

    h = ipq_create_handle(0, PF_INET);

    if (!h)
        die(h);

    status = ipq_set_mode(h, IPQ_COPY_PACKET, BUFSIZE);     //Copy Mode

    if (status < 0)
        die(h);


    do{
        if(flag == true){
        status = ipq_read(h, buf[i], BUFSIZE,0);
        }
        else{
        gettimeofday(&tv1, NULL);                             //First read has a blocking behavior
        status = ipq_read(h, buf[i], BUFSIZE,time_read);        //the next in line instead not.
        gettimeofday(&tv2, NULL);
        }


        if(flag == false){
        time_elapsed=diff_time(tv1,tv2);
        time_total=count_down(time_elapsed,time_total);
        }
        time_read=(time_total.tv_sec*1000000) + time_total.tv_usec;

        if (status < 0)
            die(h);

        if(status == 0)                       //Modify the indexes
        i--;                                  //in case of timeout.


        switch (ipq_message_type(buf[i])) {                            //Switch if we have an error or a data packet.
            case NLMSG_ERROR:
                fprintf(stderr, "Received error message %d\n",
                        ipq_get_msgerr(buf[i]));
                break;
            case IPQM_PACKET: {
                if(status != 0){
                ipq_packet_msg_t *m = ipq_get_packet(buf[i]);
                queue.push_back(m);                              //Saving in a temporary queue.
                }
                i++;

                flag = false;                                   //We are after the first packet.

                if(i == count  || status == 0 || (time_total.tv_sec<=0 && time_total.tv_usec<=0))               //Full block, read expired, or out of time.
                {
                    flag = true;                            //Flag reset because we are going to start a new block.

                    send(block_size,int_depth,h,queue,i);

                    queue.clear();
                    time_total.tv_sec=timeout_sec;          //Timer and queue reset
                    time_total.tv_usec=timeout_usec;
                    i = 0;
                }

                if (status < 0)
                    die(h);
                break;
                }
            default:
                fprintf(stderr, "Unknown message type!\n");
                break;
                }
        } while (1);
        ipq_destroy_handle(h);
    return 0;
}
