#!/bin/bash

 #######################################
 ### YOU CAN SET VARIABLES LIST BELOW ###
 #######################################
 #set output interface
 iface=eth0
 #set transport protocol
 proto=UDP
 #set destination port of stream
 dport_stream=8999
 #set destination ip of stream and measure
 dest_ip=192.168.1.1
 #set destination port of measure
 dport_measure=8888
 #set measure time
 t_m=60000
 #set pps of measure
 rate_misura=50
 #set packet size of measure
 pktsize=50
 #set path to D-ITG bin folder
 path_ditg=/home/ruggiero/D-ITG-2.7.0-Beta2/bin
 #set path to TimeD (please include binary name too)
 path_td=/home/ruggiero/td_0.2
 #set directory to save log file
 log_dir=/home/ruggiero/Log_misure_TimeD
 #############################################
 ### END LIST OF VARIABLES THAN YOU CAN SET###
 #############################################


 #needed index for distinguish log files
 i=1


 ##extract the name of timed application from full path
 td_name=`basename $path_td`
 echo "Press Ctrl-C to terminate this script"
 #pid of various application of interest
 pid_of_itglog=`pidof ITGLog`
 pid_of_td=`pidof $td_name`


 #intercept Ctrl+C, so I can delete all related file and kill all related application
 trap 'rm -f ~/ITGSend_error.log && rm -f ~/misura_* && echo "Killing all related process" && killall $td_name ITGSend misura.sh 2> /dev/null' 2

 echo "Insert destination ip [press enter for default ($dest_ip)]: ";
 read ip_dest
 if [[ $ip_dest = "" ]];then
 ip_dest=$dest_ip
 fi

 ip_source=`ifconfig $iface | grep 'inet addr' | cut -d " " -f 12 - | cut -d ":" -f2 -`


 if [[ $pid_of_itglog = "" ]];then
 echo "Starting ITGLog..."
 $path_ditg/ITGLog > /dev/null &
 fi

 #function measure
 function measure {
 echo "Starting ITGSend..."
 start_time_script=`date +%s`
 $path_ditg/ITGSend -a $ip_dest -rp $dport_measure -T $proto -t $t_m -C $rate_misura -c $pktsize -l ~/misura_sender_rate"$rate_misura"pps@"$pktsize"byte_$1.bin -L $ip_source TCP -x ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_$1.bin -X $ip_source TCP 2>~/ITGSend_error.log

 if grep -q -i error ~/ITGSend_error.log
 then echo "ERROR: Some errors occurred in ITGSend. ITGSend report:"
 echo "##################################"
 cat ~/ITGSend_error.log
 rm -f ~/ITGSend_error.log
 echo "##################################"
 echo "Killing all related process and file"
 killall $td_name ITGLog ITGSend misura.sh 2> /dev/null
 fi

 echo "Starting ITGDec..."
 $path_ditg/ITGDec ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_$1.bin -v -l ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_$1.dec > ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_$1.terminal
 echo " "
 cat ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_$1.terminal | grep dropped | cut -d "=" -f2 - | sed -e "s/[[:space:]]*//" | head -n 1 | cut -d "(" -f2 | cut -d " " -f1 > ~/misura_dropped_rate"$rate_misura"pps@"$pktsize"byte_$1.txt
 read -d EOF pi < ~/misura_dropped_rate"$rate_misura"pps@"$pktsize"byte_$1.txt
 cat ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_$1.terminal | grep burst | cut -d "=" -f2 - | sed -e "s/[[:space:]]*//" | tail -n 1 | cut -d " " -f1 > ~/misura_burst_rate"$rate_misura"pps@"$pktsize"byte_$1.txt
 read -d EOF rho < ~/misura_burst_rate"$rate_misura"pps@"$pktsize"byte_$1.txt
 echo "DECpi=$pi"
 echo "DECburst=$rho"

 #estimation of rho:
 Tb=$rho
 q=`echo "scale=4;1/$Tb" | bc`
 p=`echo "scale=4;($pi/100)/($Tb-(($pi/100)*$Tb))" | bc`

 rho_dec=`echo "scale=4;(1-$q)/$p" | bc`


 if [[ $rho_dec = "" ]];then
 rho_dec=0
 fi

 tempo=`date +%s`
 if [[ $i = "1" ]];then
 echo -e "start_script\t"$start_time_script"" >> ~/Log_misura_rate"$rate_misura"pps@"$pktsize"byte_"$t_m"ms.log
 echo -e ""$i"\t"$tempo"\t"$pi"\t"$rho"\t"$rho_dec"" >> ~/Log_misura_rate"$rate_misura"pps@"$pktsize"byte_"$t_m"ms.log
 else
 echo -e ""$i"\t"$tempo"\t"$old_pi"\t\t\t"$old_rho_dec"" >> ~/Log_misura_rate"$rate_misura"pps@"$pktsize"byte_"$t_m"ms.log
 echo -e ""$i"\t"$tempo"\t"$pi"\t"$rho"\t"$rho_dec"" >> ~/Log_misura_rate"$rate_misura"pps@"$pktsize"byte_"$t_m"ms.log
 fi

 echo "estimated_rho=$rho_dec"
 return 0
 }

 #function matrix dimension
 function matrix {

 if [[ `echo "$pi<1" | bc` -eq 1 ]];then
	 n=1
	 m=1
 fi

 if [[ `echo "$pi>=1" | bc` -eq 1 && `echo "$pi<2" | bc` -eq 1]];then
	 if [[ `echo "$rho<=1" | bc` -eq 1 ]];then
		 n=1
		 m=1
	 fi
	 if [[ `echo "$rho>1" | bc` -eq 1 && `echo "$rho<=22" | bc` -eq 1 ]];then
		 n=6
		 m=8
	 fi
	 if [[ `echo "$rho>22" | bc` -eq 1 && `echo "$rho<=30" | bc` -eq 1 ]];then
		 n=12
		 m=4
	 fi
	 if [[ `echo "$rho>30" | bc` -eq 1 ]];then
		 n=24
		 m=2
	 fi
 fi

 if [[ `echo "$pi>=2" | bc` -eq 1 && `echo "$pi<5" | bc` -eq 1]];then
	 if [[ `echo "$rho<=1" | bc` -eq 1 ]];then
		 n=1
		 m=1
	 fi
	 if [[ `echo "$rho>1" | bc` -eq 1 && `echo "$rho<=11" | bc` -eq 1 ]];then
		 n=6
		 m=8
	 fi
	 if [[ `echo "$rho>11" | bc` -eq 1 && `echo "$rho<=30" | bc` -eq 1 ]];then
		 n=12
		 m=4
	 fi
	 if [[ `echo "$rho>30" | bc` -eq 1 ]];then
		 n=24
		 m=2
	 fi
 fi

 if [[ `echo "$pi>=5" | bc` -eq 1 && `echo "$pi<15" | bc` -eq 1 ]];then
	 if [[ `echo "$rho<=1" | bc` -eq 1 ]];then
		 n=1
		 m=1
	 fi
	 if [[ `echo "$rho>1" | bc` -eq 1 && `echo "$rho<=22" | bc` -eq 1 ]];then
		 n=12
		 m=4
	 fi
	 if [[ `echo "$rho>22" | bc` -eq 1 ]];then
		 n=24
		 m=2
	 fi
 fi

 if [[ `echo "$pi>=15" | bc` -eq 1 ]];then
	 if [[ `echo "$rho<=1" | bc` -eq 1 ]];then
		 n=1
		 m=1
		 else
			 n=24
			 m=2
	 fi
 fi
 }


 measure $i
 matrix

 n_old=1


 mkdir $log_dir


 while :
 do
	 if [[ $n_old -ne $n ]];then #if depth was changed i will kill and restart timed
		 iptables -F
		 pid_of_td=`pidof $td_name`
		 kill -9 $pid_of_td
		 echo "stopping TimeD"
		 echo "`date +%T` restarting Timed con n=$n e m=$m"
		 $path_td -n $n -m $m &> ~/timed_$i.log &
		 iptables -A OUTPUT -o $iface --destination $ip_dest -p $proto --dport $dport_stream -j QUEUE
	 fi

	 #sleep 8 ##in the future version will be a good approach wait an amount of time before restarting measure
	 #restart measure
	 let i++
	 ##save old_rho_dec and old_pi to passing them to the measure function
	 old_rho_dec=$rho_dec
	 old_pi=$pi
	 measure $i $old_rho_dec $old_pi
	 n_old=$n
	 matrix
	 #save binary log of sender and receiver for future investigation:
	 mv ~/misura_receiver_rate"$rate_misura"pps@"$pktsize"byte_*.bin $log_dir
	 mv ~/misura_sender_rate"$rate_misura"pps@"$pktsize"byte_*.bin $log_dir
 done

 exit 0
