% Calcola il vettore delle distorioni normalizzate 
% al variare delle lunghezze dei burst 


%     distorsioni = calcola_distorsioni(B,D,n_lunghezze)


% riceve in ingresso due vettori 'B' e 'D' contenenti rispettivamente:
% B : le lunghezze dei burst
% D : le distorsioni associate alle relative lunghezze  
%     normalizzata per la distorsione unitaria.

% NB:  richiesto sempre 2 come primo valore per B

% procede INTERPOLANDO all'interno del range delle lunghezze 
% contenuto in B ed ESTRAPOLANDO i dati all'esterno

% NB : l'estrapolazione pu risultare in pratica una previsione non
%      valida!!!! V quindi gestita con cura.

% riceve in ingresso anche il numero di lunghezze dei burst 
% 'n_lunghezze' richiesto che corrisponde all'estremo superiore 
% dell'itervallo di estrapolazione
%restituisce il vettore delle distorsioni normalizzate associate alle varie
%lunghezze dei burst


function distorsioni = calcola_distorsioni(B,D,n_lunghezze)


x=B;
y=D;

n=size(x,2); 

% NB : x e y devono avere lo stesso numero di elementi


% inizializzo alla distorsione unitaria supponendo che x(1)=2

distorsioni=1; 


%INTERPOLAZIONE

for i=1:n-1
    b=[x(i),x(i+1)];
    l=[y(i),y(i+1)];
    p=polyfit(b,l,1);
    t=[x(i):1:(x(i+1)-1)];
    f=p(1)*t+p(2);   
    distorsioni=[distorsioni,f];
end


%ESTRAPOLAZIONE

t=[x(n):1:n_lunghezze];
f=p(1)*t+p(2);  
distorsioni=[distorsioni,f];

    
    
    
    
    
    