%interleaving_all

%effettua l'interleaving su di un'intera sequenza di dati
%NB : bisogna imporre il controllo sul fatto che l'intera sequenza sia
%lunghezza pari ad un multiplo della lunghezza del blocco m*n scelto
%NB : bisogna effettuare il controllo : l=n*m

function S = interleaving_all(l,n,m,L)

% l : lunghrzza del blocco  l=n*m
% n : numero righe
% m : numero colonne
% L : lunghezza dell'intera sequenza : q = L/l intero

q=L/l;


%genero q blocchi lunghi l
K = seq_gen(l,q);

%effettuo l'interleaving su ogni blocco
for i=1:q;
    Si(:,:,i) = interleaving (K(:,:,i),n,m);
end

%metto i blocchi in un'unica sequenza che  il paramentro di uscita della
%funzione
S=Si(:,:,1);

for i=2:q 
      S=[S,Si(:,:,i)];
end
   



%questo modulo dovrebbe essere opportunamente modificato in modo che possa
%accettare anche la sequenza di dati in ingresso strutturati come array
%multidimensionali senza generarne una con la funzione seq_gen