% funzione per il calcolo della lunghezza media e della varianza 
% della lunghezza dei burst


function [M,Var]=stat_burstl(I,k)


% M : lunghezza media dei bursts di 'k' presenti nella sequenza I
% Var : varianza lunghezza dei bursts
% I : traccia relativa alla sequenza con le perdite indicate con
%     '0' nel nostro caso


L=size(I,2);


% chiamo la funzione countburst() per ottenere la disribuzione 
% delle occorrenze dei burst.

B=countburst(I,k); 

n=size(B,2);

K=0;
j=0;

for i=1:L
    K=K+(i^2)*B(i);
    if (B(i)~=0) j=B(i)+j; %numero di occorrenze dei burst  
    end
end


% calcolo la media del processo al quadrato!

M_2=K/j;     


%Calcolo la Media

M=((1:length(B))*B')/sum(B); 


%Calcola la Varianza

Var=M_2-M^2;