% funzione per il calcolo della lunghezza media e della varianza
% delle sequenze no-loss (distanza media fra le perdite)


function [M,Var]=stat_nolossesl(I,k)


% M : lunghezza media delle sequenze no-loss in 'I'
% Var : varianza della lunghezza delle sequenze no-loss
% I : traccia relativa alla sequenza con le perdite indicate con
%     '0' nel nostro caso
% k : numero che indica una perdita


L=size(I,2);


% chiamo la funzione nolossesl() per ottenere la disribuzione 
% delle occorrenze delle sequenze no-loss.

B=nolossesl(I,k); 

n=size(B,2);

K=0;
j=0;

for i=1:L
    K=K+(i^2)*B(i);
    if (B(i)~=0) j=B(i)+j; %numero di occorrenze dei burst no-loss(contando anche quelli lunghi 1)
    end
end

M_2=K/j;     % la media del processo al quadrato!

%Calcolo la Media

M=((1:length(B))*B')/sum(B); 

%Calcola la Varianza

Var=M_2-M^2;