%Test interleaving per la funzione confronto
%l : lunghezza del blocco
%L : lunghezza della sequenza
%Depth : numero che contiene la profondit n=Depth del'interleaving ,ovvero numero di righe. (m=l/n)
%loss : probabilit di perdita del path
%rho : memoria del path
%times : numero di volte che si ripeter la misura per poi mediare
%Dmedia : distorsione mediata su times volte associata alla sequenza nel
%caso Foreman e Clare
%LmediaB : lunghezza media dei bursts dopo il deinterleaving
%VarB: varianza delle lunghezze dei burst


function [Dmedia_F,Dmedia_C,LmediaB,VarB,LmediaNL,VarNL,Nlosses]=test_int_new(l,L,Depth,loss,rho,times)
%,DistrB
%,DistrNL




    m=l/Depth;   %imporre il controllo ke sia intero
    I=interleaving_all(l,Depth,m,L);
    
 for i=1:times
    
    C=path(I,loss,rho);
    
    H=deinterleaving_all(C,Depth,m);
    
    [D_F(i),D_C(i)]=distortion_new(H);
    
    [m_B(i),var_B(i)]=stat_burstl(H,0);   
    [m_NL(i),var_NL(i)]=stat_nolossesl(H,0);
    
    N(i)=countlosses(H);
 end


 Dmedia_F=sum(D_F)/i;
 Dmedia_C=sum(D_C)/i;

 LmediaB=sum(m_B)/i;
 VarB=sum(var_B)/i;
%DistrB=sum(distr_B)/i;

LmediaNL=sum(m_NL)/i;
VarNL=sum(var_NL)/i; 
%DistrNL=sum(distr_NL)/i;

Nlosses=sum(N)/i;
end
