/*
 *   ippo-lib - IP oPtion-based active PrObing
 *   An Active Probing Library for IP Options Equipped probes (http://traffic.comics.unina.it/ippolib)
 *
 *   Copyright    : (C) 2012 by Pietro Marchetta, Walter de Donato, Francesco Cesareo,
 *                                     Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *
 *   email        : pietro.marchetta@unina.it , walter.dedonato@unina.it , cesareo.francesco@gmail.com
 * 										pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "checksum.h"

#include <sys/types.h>
#include <netinet/in.h>

uint16_t udp_sum_calc( uint16_t len_udp,
                  uint32_t src_addr,
                  uint16_t src_port,
                  uint32_t dest_addr,
                  uint16_t dest_port,
                  const void * buff
                )
{
        uint16_t prot_udp        = 17;
        uint16_t chksum_init     = 0;
        uint16_t udp_len_total   = 0;
        uint32_t sum             = 0;
        uint16_t pad             = 0;
        uint16_t low;
        uint16_t high;
        int i;

        /* if we have an odd number of bytes in the data payload, then set the pad to 1
         * for special processing
         */
        if( len_udp%2 != 0 ) {
          pad = 1;
        }
        /* do the source and destination addresses, first, we have to split them
         * into 2 shorts instead of the 32 long as sent.  Sorry, that's just how they
         * calculate
         */
        low  = src_addr;
        high = ( src_addr>>16 );
        sum  += ( ( uint32_t ) high + ( uint32_t ) low );

        /* now do the same with the destination address */
        low  = dest_addr;
        high = ( dest_addr>>16 );
        sum  += ( ( uint32_t ) high + ( uint32_t ) low );

        /* the protocol and the number and the length of the UDP packet */
        udp_len_total = len_udp + 8;  /* length sent is length of data, need to add 8 */
        sum += ( ( uint32_t )prot_udp + ( uint32_t )udp_len_total );


        /* next comes the source and destination ports */
        sum += ( ( uint32_t )src_port + ( uint32_t ) dest_port );

        /* Now add the UDP length and checksum=0 bits
         * The Length will always be 8 bytes plus the length of the udp data sent
         * and the checksum will always be zero
         */
        sum += ( ( uint32_t ) udp_len_total + ( uint32_t ) chksum_init );


        /* Add all 16 bit words to the sum, if pad is set (ie, odd data length) this will just read up
         * to the last full 16 bit word.
         * */
        for( i=0; i< ( len_udp - pad ); i+=2 ) {
          high  = ntohs(*(uint16_t *)buff);
          buff +=2;
          sum  += ( uint32_t ) high;
        }

        /* ok, if pad is true, then the pointer is now  right before the last single byte in
         * the payload.  We only need to add till the end of the string (1-byte) , not the next 2 bytes
         * as above.
         */
        if( pad ) {
          sum += ntohs( * ( unsigned char * ) buff );
        }

        /* keep only the last 16 bits of the 32 bit calculated sum and add the carry overs */
        while ( sum>>16 ) {
          sum = ( sum & 0xFFFF ) + ( sum >> 16 );
        }

        /* one's compliment the sum */
        sum = ~sum;

        /* finally, return the 16bit network formated checksum */
        return ((uint16_t) htons(sum) );
};


uint16_t udp_sum_calc2(uint16_t len_udp, uint16_t src_addr[],uint16_t dest_addr[], bool padding, uint16_t buff[])
{
uint16_t prot_udp=17;
uint16_t padd=0;
uint16_t word16;
uint32_t sum;

        printf("*");
        fflush ( stdout );
        // Find out if the length of data is even or odd number. If odd,
        // add a padding byte = 0 at the end of packet
        if (padding==true){
                padd=1;
                buff[len_udp]=0;
        }
        printf("*");
        fflush ( stdout );
        //initialize sum to zero
        sum=0;

        // make 16 bit words out of every two adjacent 8 bit words and
        // calculate the sum of all 16 bit words
        int i=0;
        for (i=0;i<len_udp+padd;i=i+2){
                word16 =((buff[i]<<8)&0xFF00)+(buff[i+1]&0xFF);
                sum = sum + (unsigned long)word16;
        }
        printf("*");
        fflush ( stdout );
        // add the UDP pseudo header which contains the IP source and destinationn addresses
        for (i=0;i<4;i=i+2){
                word16 =((src_addr[i]<<8)&0xFF00)+(src_addr[i+1]&0xFF);
                sum=sum+word16;
        }
        printf("*");
        fflush ( stdout );
        for (i=0;i<4;i=i+2){
                word16 =((dest_addr[i]<<8)&0xFF00)+(dest_addr[i+1]&0xFF);
                sum=sum+word16;
        }
        // the protocol number and the length of the UDP packet
        sum = sum + prot_udp + len_udp;

        // keep only the last 16 bits of the 32 bit calculated sum and add the carries
        while (sum>>16)
                sum = (sum & 0xFFFF)+(sum >> 16);

        // Take the one's complement of sum
        sum = ~sum;

return ((uint16_t) sum);
}


u_short in_chksum (u_short *addr, int len) {

int nleft = len, sum = 0;
u_short *w = addr, answer = 0;

        while (nleft > 1) {
                sum += *w++;
                nleft -= 2;
        }

        if (nleft == 1) {
                *(u_char *)(&answer) = *(u_char *)w;
                sum += answer;
        }

        sum = (sum >> 16) + (sum + 0xffff);
        sum += (sum >> 16);
        answer = ~sum;
        return(answer);
}


unsigned short in_chksum_udp(  unsigned short *h, unsigned short * d, int dlen )
{
   unsigned int cksum;
   unsigned short answer=0;

   /* PseudoHeader must have 12 bytes */
   cksum  = h[0];
   cksum += h[1];
   cksum += h[2];
   cksum += h[3];
   cksum += h[4];
   cksum += h[5];

   /* UDP must have 8 hdr bytes */
   cksum += d[0];
   cksum += d[1];
   cksum += d[2];
   cksum += d[3];

   dlen  -= 8; /* bytes   */
   d     += 4; /* short's */

   while(dlen >=32)
   {
     cksum += d[0];
     cksum += d[1];
     cksum += d[2];
     cksum += d[3];
     cksum += d[4];
     cksum += d[5];
     cksum += d[6];
     cksum += d[7];
     cksum += d[8];
     cksum += d[9];
     cksum += d[10];
     cksum += d[11];
     cksum += d[12];
     cksum += d[13];
     cksum += d[14];
     cksum += d[15];
     d     += 16;
     dlen  -= 32;
   }

   while(dlen >=8)
   {
     cksum += d[0];
     cksum += d[1];
     cksum += d[2];
     cksum += d[3];
     d     += 4;
     dlen  -= 8;
   }

   while(dlen > 1)
   {
     cksum += *d++;
     dlen  -= 2;
   }

   if( dlen == 1 )
   {
     *(unsigned char*)(&answer) = (*(unsigned char*)d);
     cksum += answer;
   }

   cksum  = (cksum >> 16) + (cksum & 0x0000ffff);
   cksum += (cksum >> 16);

   return (unsigned short)(~cksum);
}



unsigned short in_chksum_tcp(  unsigned short *h, unsigned short * d, int dlen )
{
   unsigned int cksum;
   unsigned short answer=0;

   /* PseudoHeader must have 12 bytes */
   cksum  = h[0];
   cksum += h[1];
   cksum += h[2];
   cksum += h[3];
   cksum += h[4];
   cksum += h[5];

   /* TCP hdr must have 20 hdr bytes */
   cksum += d[0];
   cksum += d[1];
   cksum += d[2];
   cksum += d[3];
   cksum += d[4];
   cksum += d[5];
   cksum += d[6];
   cksum += d[7];
   cksum += d[8];
   cksum += d[9];

   dlen  -= 20; /* bytes   */
   d     += 10; /* short's */

   while(dlen >=32)
   {
     cksum += d[0];
     cksum += d[1];
     cksum += d[2];
     cksum += d[3];
     cksum += d[4];
     cksum += d[5];
     cksum += d[6];
     cksum += d[7];
     cksum += d[8];
     cksum += d[9];
     cksum += d[10];
     cksum += d[11];
     cksum += d[12];
     cksum += d[13];
     cksum += d[14];
     cksum += d[15];
     d     += 16;
     dlen  -= 32;
   }

   while(dlen >=8)
   {
     cksum += d[0];
     cksum += d[1];
     cksum += d[2];
     cksum += d[3];
     d     += 4;
     dlen  -= 8;
   }

   while(dlen > 1)
   {
     cksum += *d++;
     dlen  -= 2;
   }

   if( dlen == 1 )
   {
    /* printf("new checksum odd byte-packet\n"); */
    *(unsigned char*)(&answer) = (*(unsigned char*)d);

    /* cksum += (u_int16_t) (*(u_int8_t*)d); */

     cksum += answer;
   }

   cksum  = (cksum >> 16) + (cksum & 0x0000ffff);
   cksum += (cksum >> 16);

   return (unsigned short)(~cksum);
}

unsigned short cksum(unsigned short *addr, int len)
{
    int nleft = len;
    int sum = 0;
    unsigned short *w = addr;
    unsigned short answer = 0;

    while (nleft > 1) {
        sum = sum + *w++;
        nleft = nleft - 2;
    }

    if (nleft == 1) {
        *(unsigned char *) (&answer) = *(unsigned char *) w;
        sum = sum + answer;
    }

    sum = (sum >> 16) + (sum & 0xffff);
    sum = sum + (sum >> 16);
    answer = ~sum;

    return answer;
}

uint16_t ip_sum_calc(uint16_t len_ip_header, uint16_t buff[])
{
uint16_t word16;
uint32_t sum=0;
uint16_t i;

        // make 16 bit words out of every two adjacent 8 bit words in the packet
        // and add them up
        for (i=0;i<len_ip_header;i=i+2){
                word16 =((buff[i]<<8)&0xFF00)+(buff[i+1]&0xFF);
                sum = sum + (uint32_t) word16;
        }

        // take only 16 bits out of the 32 bit sum and add up the carries
        while (sum>>16)
          sum = (sum & 0xFFFF)+(sum >> 16);

        // one's complement the result
        sum = ~sum;

return ((uint16_t) sum);
}
