/*
 *   ippo-lib - IP oPtion-based active PrObing
 *   An Active Probing Library for IP Options Equipped probes (http://traffic.comics.unina.it/ippolib)
 *
 *   Copyright    : (C) 2012 by Pietro Marchetta, Walter de Donato, Francesco Cesareo,
 *                                     Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *
 *   email        : pietro.marchetta@unina.it , walter.dedonato@unina.it , cesareo.francesco@gmail.com
 * 										pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef GENERALOPTION_H
#define GENERALOPTION_H

#include <string>

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include <arpa/inet.h>

typedef unsigned short	uint16;
typedef unsigned int	uint32;

class GeneralOption
{
private:
    bool    _verbose_mode;
    int     _retries;
    int     _timeout;
    int     _ttl;

    pid_t   _ipid;
    int     _protocol_number;

    std::string _eth;

    uint16  _src_port;
    uint16  _dst_port;

    int     _socketudp;
    pthread_mutex_t _lock;

    void _default_value();

public:
    GeneralOption();
    GeneralOption(int socketudp);
    GeneralOption(int socketudp, pthread_mutex_t lock);

    ~GeneralOption();

    int retries();
    void set_retries(int retries);

    int timeout();
    void set_timeout(int timeout);

    int ttl();
    void set_ttl(int ttl);

    pid_t ip_id();

    std::string eth();
    void set_eth(std::string eth);

    int socketudp();
    void set_socketudp(int socketudp);

    pthread_mutex_t lock();
    void set_lock(pthread_mutex_t lock);

    int protocol_number();
    void set_protocol_number(int protocol_number);

    bool verbose_mode();
    void set_verbose_mode(bool verbose_mode);

    uint16 src_port();
    void set_src_port(uint16 src_port);

    uint16 dst_port();
    void set_dst_port(uint16 dst_port);
};

#endif // GENERALOPTION_H
