/*
 *   ippo-lib - IP oPtion-based active PrObing
 *   An Active Probing Library for IP Options Equipped probes (http://traffic.comics.unina.it/ippolib)
 *
 *   Copyright    : (C) 2012 by Pietro Marchetta, Walter de Donato, Francesco Cesareo,
 *                                     Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *
 *   email        : pietro.marchetta@unina.it , walter.dedonato@unina.it , cesareo.francesco@gmail.com
 * 										pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef IPPOLIB_H
#define IPPOLIB_H

#include "probereply.h"
#include "generaloption.h"

#define NIPS 4

typedef u_int8_t uint8;

typedef struct pseudoheader       // pseudo header for TCP checksum calculations
{
    u_int32_t sip, dip;   // IP addr
    u_int8_t  zero;       // checksum placeholder
    u_int8_t  protocol;   // protocol number
    u_int16_t tcplen;     // tcp packet length
}pseudoheader;

class IPPOLib
{
private:

    int _retrieve_src_addr(uint32& src_addr_raw, GeneralOption* option);

    int _udp(GeneralOption* option, ProbeReply* reply, std::string dst_addr);
    int _udp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_ip_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);

    int _icmp(GeneralOption* option, ProbeReply* reply, std::string dst_addr);
    int _icmp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_ip_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);

    int _tcp(GeneralOption* option, ProbeReply* reply, std::string dst_addr);
    int _tcp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_ip_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);

    int _protocol(GeneralOption* option, ProbeReply* reply, std::string dst_addr);
    int _protocol_ts(GeneralOption* option, ProbeReply* reply, std::string dst_ip_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);

    public:
    IPPOLib();
    ~IPPOLib();

    // UDP
    int udp(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send UDP to D
    // UDP_TS
    int udp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send UDP_TS to D|DDDD
    int udp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1);  // send UDP_TS to D|XXXX
    int udp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2);  // send UDP_TS to D|XYYY
    int udp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3);  // send UDP_TS to D|XYZZ
    int udp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);  // send UDP_TS to D|XYZW

    // ICMP
    int icmp(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send ICMP to D
    // ICMP_TS
    int icmp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send ICMP_TS to D|DDDD
    int icmp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1);  // send ICMP_TS to D|XXXX
    int icmp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2);  // send ICMP_TS to D|XYYY
    int icmp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3);  // send ICMP_TS to D|XYZZ
    int icmp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);  // send ICMP_TS to D|XYZW

    // TCP
    int tcp(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send TCP to D
    // TCP_TS
    int tcp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send TCP_TS to D|DDDD
    int tcp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1);  // send ICMP_TS to D|XXXX
    int tcp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2);  // send ICMP_TS to D|XYYY
    int tcp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3);  // send ICMP_TS to D|XYZZ
    int tcp_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);  // send ICMP_TS to D|XYZW

    // PROTOCOL
    int protocol(GeneralOption* option, ProbeReply* reply, std::string dst_addr);
    // PROTOCOL_TS
    int protocol_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr); // send PROTOCOL_TS to D|DDDD
    int protocol_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1);  // send ICMP_TS to D|XXXX
    int protocol_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2);  // send ICMP_TS to D|XYYY
    int protocol_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3);  // send ICMP_TS to D|XYZZ
    int protocol_ts(GeneralOption* option, ProbeReply* reply, std::string dst_addr, std::string ts_addr_1, std::string ts_addr_2, std::string ts_addr_3, std::string ts_addr_4);  // send ICMP_TS to D|XYZW

};

#endif // IPPOLIB_H
