/*
 *   ippo-lib - IP oPtion-based active PrObing
 *   An Active Probing Library for IP Options Equipped probes (http://traffic.comics.unina.it/ippolib)
 *   Copyright    : (C) 2012 by Pietro Marchetta, Walter de Donato, Francesco Cesareo,
 *                                     Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *
 *   email        : pietro.marchetta@unina.it , walter.dedonato@unina.it , cesareo.francesco@gmail.com
 * 										pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#include "lib/ippolib.h"
#include "lib/probereply.h"
#include "lib/generaloption.h"
#include "lib/util.h"

#include <iostream>


int main()
{
    std::cout << "Hello Fast Probing!" << std::endl;

    const hostent* host = gethostbyname("www.caida.org");
    const in_addr* add_raw = (in_addr*) host->h_addr_list[0];

    std::string dst_addr = Util::number2string(add_raw->s_addr);
    std::string ts_addr = dst_addr;

    // instantiation
    IPPOLib *probe = new IPPOLib();
    ProbeReply *reply = new ProbeReply();
    GeneralOption *option = new GeneralOption();

    // setting options campaing
    option->set_verbose_mode(true); // enable verbose mode
    option->set_retries(2); // set to 2 the retry number to obtain response probe
    option->set_timeout(2000);  // set time to wait response

    // send UDP probe
    probe->udp(option,reply,Util::number2string(add_raw->s_addr));  // send UDP probe to dst_addr
    if (reply->has_response())
        reply->print();
    else
        std::cout << "No response obtained" << std::endl;

    // send UDP_TS probe
    probe->udp_ts(option,reply,dst_addr,ts_addr);   // send UDP to dst_addr prespecifying ts_addr four times as timestamp address
    if (reply->has_response())
    {
        reply->print();
    }
    else
        std::cout << "No response obtained" << std::endl;

    // send ICMP probe
    probe->icmp(option,reply,dst_addr);
    if (reply->has_response())
        reply->print();
    else
        std::cout << "No response obtained" << std::endl;

    //send ICMP_TS probe
    probe->icmp_ts(option,reply,dst_addr, ts_addr);
    if (reply->has_response())
    {
       reply->print();
    }
    else
        std::cout << "No response obtained" << std::endl;

    // send TCP probe
    probe->tcp(option,reply,dst_addr);
    if (reply->has_response())
        reply->print();
    else
        std::cout << "No response obtained" << std::endl;

    // send TCP_TS probe
    probe->tcp_ts(option,reply,dst_addr);
    if (reply->has_response())
    {
        reply->print();
    }
    else
        std::cout << "No response obtained" << std::endl;

    // send PROTOCOL probe
    probe->protocol(option,reply,dst_addr);
    if (reply->has_response())
        reply->print();
    else
        std::cout << "No response obtained" << std::endl;

    // send PROTOCOL_TS probe
    probe->protocol_ts(option,reply,dst_addr);
    if (reply->has_response())
    {
        reply->print();
    }
    else
        std::cout << "No response obtained" << std::endl;

    delete option;
    option = 0;

    delete probe;
    probe = 0;

    std::cout << "Bye bye Fast Probing!" << std::endl;
    return 0;
}
