/*
 *   ippo-lib - IP oPtion-based active PrObing
 *   An Active Probing Library for IP Options Equipped probes (http://traffic.comics.unina.it/ippolib)
 *
 *   Copyright    : (C) 2012 by Pietro Marchetta, Walter de Donato, Francesco Cesareo,
 *                                     Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *
 *   email        : pietro.marchetta@unina.it , walter.dedonato@unina.it , cesareo.francesco@gmail.com
 * 										pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef PROBEREPLY_H
#define PROBEREPLY_H

#include <string>
#include <sstream>

#include <netinet/in.h>
#include <netinet/ip.h>
#include <netinet/ip_icmp.h>
#include <netinet/udp.h>
#include <netinet/tcp.h>

#define MAX_PACKET 1500

#define IP_SIZE 20
#define IP_SIZE_TS 56

#define ICMP 0
#define ICMP_SIZE 8

#define UDP 1
#define UDP_SIZE 8

#define TCP_SIZE 20

#define NO_RESPONSE -1
#define ERROR   -8

#define TCP_RST_FLAG    60;
#define TCP_SYN_ACK     61;
#define TCP_UNKNOWN     62;

typedef unsigned short	uint16;
typedef unsigned int	uint32;

typedef struct TSOption{
    #if __BYTE_ORDER == __LITTLE_ENDIAN
        char type;
        char length;
        char pointer;
        char overflag;
    #  elif __BYTE_ORDER == __BIG_ENDIAN
        char overflag;
        char pointer;
        char length;
        char type;
    # endif

    uint32_t ip1;
    uint32_t ts1;

    uint32_t ip2;
    uint32_t ts2;

    uint32_t ip3;
    uint32_t ts3;

    uint32_t ip4;
    uint32_t ts4;
}TSOption;

class ProbeReply
{
private:

    char    _probe[MAX_PACKET];

    uint32  _src_addr_raw;
    uint32  _dst_addr_raw;

    int _protocol;
    int _ihl;
    int _code;
    int _subcode;
    int _scan_result;

    struct iphdr*   _ip_buf;
    struct icmp *   _icmp_buf;
    struct iphdr*   _iperror_buf;
    struct tcphdr*  _tcp_buf;

    bool    _has_response;
    bool    _options;

    void    _dissect();
    void    _dissect_icmp(int offset);
    void    _dissect_iperror(int offset);
    void    _dissect_tcp(int offset);

    void    _set_dst_addr();

public:
    ProbeReply();
    ~ProbeReply();

    void set_probe(char probe[MAX_PACKET]);

    std::string src_addr(); // response IP
    uint32 src_addr_raw();

    std::string dst_addr(); // sender IP
    uint32 dst_addr_raw();

    std::string iperror_dst_addr();
    uint32 iperror_dst_addr_raw();

    uint16 dst_port();

    int ip_protocol();
    int iperror_ip_protocol();
    int ihl();
    int code();
    int subcode();

    bool has_response();
    bool options(); // true if options

    bool outer_options(TSOption** opt);
    bool inner_options(TSOption** opt);

    char* probe();
    char* transport_probe();
    char* payload_probe();

    int scan_result();
    void set_scan_result(int scan_result);

    void print();
    void reset();
};

#endif // PROBEREPLY_H
