/*
 *   ippo-lib - IP oPtion-based active PrObing
 *   An Active Probing Library for IP Options Equipped probes (http://traffic.comics.unina.it/ippolib)
 *
 *   Copyright    : (C) 2012 by Pietro Marchetta, Walter de Donato, Francesco Cesareo,
 *                                     Antonio Pescape' (PI)
 *                                     of the COMICS (COMputer for Interaction and
 *                                     CommunicationS) Group, Dipartimento di Informatica
 *                                     e Sistemistica of the University of Napoli "Federico II".
 *
 *   email        : pietro.marchetta@unina.it , walter.dedonato@unina.it , cesareo.francesco@gmail.com
 * 										pescape@unina.it
 *
 *   This program is free software: you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation, either version 3 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef UTIL_H
#define UTIL_H

#include <string.h>
#include <string>
#include <stdlib.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>


typedef unsigned short	uint16;
typedef unsigned int	uint32;

class Util
{
public:
    bool mnumber2string(uint32 addr, char* toreturn);
    bool mstring2number(std::string &addr, uint32 &num);


	/**
	 * @brief string2number
	 * @brief converts IP address from dotted notation to number notation
	 * @param addr IP address in dotted notation
	 * @return uint32 IP address in number notation
	 */
	static uint32 string2number(std::string &addr)
	{
		uint32 ip;
		inet_pton(AF_INET,addr.c_str(),&ip);
		return ip;
	}
	
	/**
	 * @brief number2string
	 * @brief converts IP address from number notation to dotted notation
	 * @param addr IP address in number notation
	 * @return string IP address in dotted notation
	 */
	static char* number2string(uint32 addr)
	{
		char* ip = (char*) malloc(INET_ADDRSTRLEN);
		inet_ntop(AF_INET, &addr, ip, INET_ADDRSTRLEN);
		return ip;
	}
	
	static void number2string2(uint32 addr, char* rest)
	{
		//char* ip = (char*) malloc(INET_ADDRSTRLEN);
		inet_ntop(AF_INET, &addr, rest, INET_ADDRSTRLEN);
		//return ip;
	}
};

#endif // UTIL_H

