/*
 *  common.h
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 * 
 */

#ifndef H_COMMON
#define H_COMMON

/* #define EXTENDLOG */

/* #define DEBUG */

/* #define MACOSX */

#define PRINT_STATUS		100000		/* Print status information each PRINT_STATUS pkts processed */

#define MAX_PAYLOAD    		1550		/* 1550 */

#define DONT_SKIP_FLOW		0	/* Skip it */
#define SKIP_FLOW			1	/* Skip it */
#define TO_BE_DELETED		666 /* Must be deleted */

#define COUNT_MIN	-20
#define COUNT_MAX	20
#define COUNT_LEV	5

#define DUMP_ALL			0
#define DUMP_COMPLETE		1

#ifdef DEBUG
#define PRINTD(...);		printf(__VA_ARGS__);
#else
#define PRINTD(...);
#endif
#define PRINTDD(...);			/* to make inactive a debugging command just add a second "D" :-) */

#define MIN(a,b)		(((a) < (b)) ? (a) : (b))
#define MAX(a,b)		(((a) < (b)) ? (b) : (a))

#define ADDR2INT(a)		(u_long)((a[0] << 24) + (a[1] << 16) + (a[2] << 8) + a[3])

#ifdef MACOSX
#define TV_TO_QUAD(a)		(((u_quad_t)(a.tv_sec) * 1000000) + (u_quad_t)a.tv_usec) /* convert a timeval to an int */
#define TV_SUB_TO_QUAD(a,b)	(u_quad_t)(TV_TO_QUAD(a) - TV_TO_QUAD(b))	/* subtract 2 timevals and convert to int */
#else
#define TV_TO_QUAD(a)		(((u_quad_t)(a.tv_sec) * 1000000) + (u_quad_t)a.tv_usec) /* convert a timeval to an int */
#define TV_SUB_TO_QUAD(a,b)	(u_quad_t)(TV_TO_QUAD(a) - TV_TO_QUAD(b))	/* subtract 2 timevals and convert to int */
#endif

#define MODE_HOST	1
#define MODE_FLOW	2
#define MODE_CONV	3

typedef struct {
	int readmode;			/* read pkts from a tcpdump file rathern than from network interface */
	char *sourcefile[50];		/* tcpdump format source files name */
	int writemode;			/* dump pkts in to a tcpdump file */
	char *destfile;			/* tcpdump format destination file name */
	char *basedestfile;			
	char *destfile_mid;			
	char *destfile_end;			
	int filter_disable;		/* disable pkt filtering (and subsequently pkt processing) */
	int mss;				/* Enable MSS detection */
	int split;			
	int splitter;			
	int filter_dup;			/* filter duplicate packtes */
	int process_disable;	/* disable pkt processing */
	int filter_tcp;			/* discard tcp pkts with 0 payload */
	char *device;			/* network interface to use */
	int snaplen;			/* capture only # bytes from each pkt */
	int mode;				/* light/heavy */
	u_long start_pkts;		/* start after # pkts */
	u_long stop_pkts;		/* stop after # pkts */
	long int session_timeout;	/* expressed in seconds */
	char *directory;		/* directory where to store exported data */
	char *hosttable;		/* file form which to read host table, generated by Wmode 1 */
	char *filter_file;		/* file from which to read pcap filter commands */
	int time_range;			/* capture only pkts with timestamp in specified time range */
	int day_of_week;		/* capture only pkts with timestamp in specified day of week */
	int tr_hmin;			/* time range min hour */
	int tr_mmin;			/* time range min minute */
	int tr_hmax;			/* time range max hour */
	int tr_mmax;			/* time range max minute */
	int quiet;			/* print less info */
	int rate;			/* dump stats each "rate" seconds */
	int idt_enabled;		/* compute interarrivals */
	int dump_headers;		/* when writing to a file, truncate pkts to TCP header end + dump_headers */
	int zero;			/* zero out ip addresses in dump */
	int pl_inspect;			/* payload inspection */
	int tz;				/* timezone + daylight saving imposed by user */
	int log_ip;			/* log ip addresses of client and server */
	int wmode;			/* working mode: 1) Host  2) Flow 3) Session  4) Conversation */
	int fingerprint;	/* search for fingerprint: 1) Slammer  2) Codered */
	int service;		/* Service */
	int free_memory;	/* Memory safe processing (but slower) */
	int pl_distro;		/* Dump Payload distro */
	int absolute_ts;	/* Use Timestamps insted of Data in output files */

} program_variables;

typedef struct  {
	u_quad_t up_pkts;
	u_quad_t dw_pkts;
	u_quad_t up_bytes;
	u_quad_t dw_bytes;
	u_quad_t sessions;
	u_quad_t up_tcppkts;
	u_quad_t dw_tcppkts;
	time_t tick;
	FILE *file;
} rate_s;


typedef struct  {
	time_t cpu_start;				/* date & time when program was started */
	time_t cpu_end;					/* date & time when program finished processing data */
	int	tzoff;						/* Time zone offset */
	struct timeval tv_start;		/* timestamp of the first packet read */
	struct timeval tv_end;			/* timestamp of the last packet read */
	int frame_offset;
	u_quad_t pkts;
	u_quad_t discarded;
	u_quad_t frags;
	u_quad_t truncated;
	u_quad_t err_payload;
	u_quad_t ip_options;
	u_quad_t tcp_options;
	u_quad_t pure_tcp_pkts;
	u_quad_t skipped_pkts;
	u_quad_t bad_pkts;
	u_quad_t dup_pkts;
	int	interrupted;					/* program was interrupted by user (CTRL-C) */
	rate_s rate;						/* Rate statistics */
	u_long up_pl_distro[MAX_PAYLOAD];	/* upstream payload distribution */
	u_long dw_pl_distro[MAX_PAYLOAD];	/* downstream payload distribution */
	FILE	*fs_pl_inspect;				/* File stream to dump payload inspection data */
	FILE	*fs_idt_up;					/* File stream to dump idt up */
	FILE	*fs_idt_dw;					/* File stream to dump idt dw */
	
} statistics;

#endif
