/*
 *  conv_output.c - Plab conversations output routines
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 * 
 */

#include <pcap.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "common.h"
#include "conv_table.h"
#include "host_table.h"
#include "utils.h"
#include "conv_output.h"

extern statistics stats;
extern conv_statistics convstats;
extern program_variables pv;

void ct_display_stats()
{
	printf("Unique client-server couples found:\t%qu\n", convstats.ct_entries);
	printf("Sessions found:\t%qu\n", convstats.conversations);
}


int ct_dump_convs_data(struct ct_entry **ht, char *filename)
{
	struct timeval tv;
	FILE *fs;
	int i;
	u_long duration;
	char path[200];
	struct ct_entry *entry;
	struct conv *s;

	if (pv.directory)
		sprintf(path, "%s/%s", pv.directory, filename);
	else
		sprintf(path, "%s", filename);

	fs = fopen(path, "w");
	if (fs == NULL) {
		perror("dump_sessions_data");
		return(-1);
	}

	for(i = 0; i < CONV_TABLE_SIZE; i++) {
		entry = ht[i];
		while (entry) {
			s = entry->last_conv;
			while (s) {
				PRINTDD("Session id: [%d][%d]\n", s->entry_id, s->id);

				/* XXX Motivate this !
				if ((s->up_pkts == 1) && (s->dw_pkts == 1)) {
					continue;
				}
				*/

				if (! s->skip_conv) {
					/*
					 * Calculate session duration in milliseconds
					 */
					tvsub(&tv, s->ts_last, s->ts_start);
					/* add microseconds */
					if ((tv.tv_usec % 1000) >= 500)
						duration = (tv.tv_usec / 1000) + 1;
					else
						duration = (tv.tv_usec / 1000);
					/* add seconds */
					duration = duration + (tv.tv_sec * 1000);
				
/*					fprintf(fs, "%lu %d%.2d%.2d-%.2d:%.2d.%.2d %qu %lu %lu %lu %lu %lu\n", s->id, 
					    tztime(&(s->ts_start.tv_sec))->tm_year + 1900,
			    		    tztime(&(s->ts_start.tv_sec))->tm_mon + 1,
			    		    tztime(&(s->ts_start.tv_sec))->tm_mday,
			    		    tztime(&(s->ts_start.tv_sec))->tm_hour,
			    		    tztime(&(s->ts_start.tv_sec))->tm_min,
			    		    tztime(&(s->ts_start.tv_sec))->tm_sec,
					    s->iat,
					    s->up_pkts, s->dw_pkts, s->up_bytes, s->dw_bytes, duration); */

					fprintf(fs, "%lu %qu %lu %lu %lu %lu %lu\n", s->id, 
					    s->iat, s->up_pkts, s->dw_pkts, s->up_bytes, s->dw_bytes, duration);					
						
				}

				s = s->prev;
			}
			entry = entry->next;
		}
	}

	fclose(fs);
	return(0);
}

int ct_dump_host_data(struct ht_entry **ht, char *filename)
{
	FILE *fs;
	int i;
	char path[200];
	struct ht_entry *m_entry;

	if (pv.directory)
		sprintf(path, "%s/%s", pv.directory, filename);
	else
		sprintf(path, "%s", filename);

	fs = fopen(path, "w");
	if (fs == NULL) {
		perror("dump_host_data");
		return(-1);
	}

	for(i = 0; i < HOST_TABLE_SIZE; i++) {
		m_entry = ht[i];
		while (m_entry) {
			fprintf(fs, "%d.%d.%d.%d\t%d\n", m_entry->key[0],
			    m_entry->key[1], m_entry->key[2], m_entry->key[3], m_entry->count);
			m_entry = m_entry->next;
		}
	}

	fclose(fs);
	return(0);
}


int ct_dump_report(FILE *fs)
{
	
	/* Sessions etc. */
	fprintf(fs, "\n");
	fprintf(fs, "Unique client-server couples found:\t%qu\n", convstats.ct_entries);
	fprintf(fs, "Sessions found:\t\t\t\t%qu\n", convstats.conversations);
	fprintf(fs, "Skipped sessions:\t\t\t\t%qu\n", convstats.skipped_convs);
	fprintf(fs, "Skipped packets:\t\t\t\t%qu\n", stats.skipped_pkts);

	fclose(fs);
	return(0);
}

