/*
 *  conv_table.h - Plab
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it, a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 *
 */

#ifndef H_CONV_TABLE
#define H_CONV_TABLE

#define CONV_TABLE_SIZE 	1572869	/* needs to be a prime number */
#define VALID_UP_PKTS		4	/* minimum number of upstream pkts to make session valid */
#define VALID_DW_PKTS		2	/* minimum number of downstream pkts to make session valid */

struct conv {
	u_long id;
	int entry_id;
	struct timeval ts_last;			/* timestamp of last pkt */
	struct timeval ts_start;		/* timestamp of first pkt */
	u_long up_pkts;					/* number of upstream pkts */
	u_long up_bytes;				/* number of upstream bytes */
	struct timeval up_ts_last;		/* timestamp of last upstream pkt */
	u_long dw_pkts;					/* number of downstream pkts */
	u_long dw_bytes;				/* number of downstream bytes */
	int mss;

	struct timeval dw_ts_last;		/* timestamp of last downstream pkt */
	u_long peers;				/* number of peers */
	struct conv *prev;			/* previous session (pointer to next linked list entry) */
	u_quad_t iat;				/* interarrival time wrt the previous session */
	int skip_conv;			/* 1 if session must be skipped */
};

struct ct_entry {
	u_char	key[8];			/* key of this entry (src_ip + dst_ip) */
	u_long	id;
	u_long	num_convs;		/* number of sessions with this key */
	struct conv	*last_conv;	/* pointer to linked list of conversstions */
	struct ct_entry *next;	/* pointer to the next entry w/ different key but same mapping */
};

/* conv_statistics defined to store specifc statistics about conversations */

typedef struct  {
	u_quad_t conversations;
	u_quad_t ct_convs;
	u_quad_t ct_entries;
	u_quad_t ht_entries;
	u_quad_t skipped_convs;
	struct timeval tv_last_conv;	/* Timestamp of latest conversation arrival */
	FILE	*fs_conv_data;		/* File stream to dump conversations data */
	FILE	*fs_conv_iat;		/* File stream to dump conversation inter arrival times */
	FILE	*fs_log_ip;				/* File stream to dump IPs */

} conv_statistics;

void ct_init_table(struct ct_entry **);
u_long ct_hash(u_char *);
struct ct_entry *ct_dup_check(u_char *, struct ct_entry **, u_long);
struct ct_entry *ct_add_entry(u_char *, struct ct_entry **, u_long);
struct ct_entry *ct_get_entry(u_char *, struct ct_entry **);
int deleteconv(struct conv **);
struct conv *conv_init(struct conv *);

#endif


