/*
 *  flow_output.c - Plab conversations output routines
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 * 
 */

#include <pcap.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "common.h"
#include "flow_table.h"
#include "host_table.h"
#include "utils.h"
#include "flow_output.h"

extern statistics stats;
extern flow_statistics flowstats;
extern host_statistics hoststats;
extern program_variables pv;

void ft_display_stats()
{
	printf("Total hosts found:\t%lu\n", hoststats.ht_entries);
	printf("Unique flows found:\t%qu\n", flowstats.ft_entries);
	printf("Total flows  found:\t%qu\n", flowstats.flows);
}


int ft_dump_flows_data(struct ft_entry **ft, struct ht_entry **ht, int dumpwho)
{
	u_long i;
	u_long duration;
	struct ft_entry *m_entry;
	struct flow *s;
	struct timeval tv;
	struct ht_entry *h_entry;

	for(i = 0; i < FLOW_TABLE_SIZE; i++) {
		m_entry = ft[i];
		while (m_entry) {
			s = m_entry->last_flow;
			while (s) {
				if ((dumpwho == DUMP_ALL)||((dumpwho == DUMP_COMPLETE)&&((stats.tv_end.tv_sec-s->ts_last.tv_sec) > pv.session_timeout))) {
					
					PRINTDD("Flow id: [%qu][%qu]\n", m_entry->id, s->id);
					if (! s->skip_flow) {
						/*
						 * Calculate session duration in milliseconds
						 */
						tvsub(&tv, s->ts_last, s->ts_start);
						/* add microseconds */
						if ((tv.tv_usec % 1000) >= 500)
							duration = (tv.tv_usec / 1000) + 1;
						else
							duration = (tv.tv_usec / 1000);
						/* add seconds */
						duration = duration + (tv.tv_sec * 1000);
						

						/* get host ID when you give -H option: read table from host elaboration*/
						if (pv.hosttable) {
							h_entry = ht_lookup_entry(m_entry->key, ht);
							if (h_entry) {
								fprintf(flowstats.fs_flow_data, "%lu %qu %qu %lu %qu %lu",
										h_entry->id, s->id, 
										s->iat, s->pkts, s->bytes, duration);							
								
							} else {
								fprintf(flowstats.fs_flow_data, "-1 %qu %qu %lu %qu %lu",
										s->id, s->iat, s->pkts, s->bytes, duration);						
								PRINTD("ft_process_packet: no host in table\n");
							}
						} else {
							fprintf(flowstats.fs_flow_data, "%qu %qu %lu %qu %lu", s->id, s->iat, s->pkts, s->bytes, duration);
						}

						if (pv.fingerprint) {
							fprintf(flowstats.fs_flow_data, " %d\n", s->status);
						} else {
							fprintf(flowstats.fs_flow_data, "\n");
						}							
					}

					
					/* Mark flow to be deleted */
					s->skip_flow=TO_BE_DELETED;
				}
				
				s=s->prev;
			}

			m_entry = m_entry->next;
		}
	}
	
	fflush(flowstats.fs_flow_data);
	return(0);
}

int ft_free_flows(struct ft_entry **ft)
{
	u_long i;
	struct flow *s,*prevptr;
	struct ft_entry *entry;
	
	for(i = 0; i < FLOW_TABLE_SIZE; i++) {
		entry = ft[i];
		while (entry) {
			s = entry->last_flow;
			prevptr= entry->last_flow;							
			while (s) {
			
				if (s->skip_flow==TO_BE_DELETED) {
					if (s==entry->last_flow) {
						if (delete_flow(&s)) return (-1);
						entry->last_flow = s;
						prevptr = s;
					} else {
						if (delete_flow(&s)) return (-1);
						prevptr->prev = s;
					}
				} else {
					prevptr = s;
					s = s->prev;
					
				}
			}
			entry = entry->next;
		}
	}
	
	return (1);
}

int ft_dump_report(FILE *fs)
{
	
	/* Flows etc. */
	fprintf(fs, "\n");
	fprintf(fs,"Total hosts found:\t%lu\n", hoststats.ht_entries);
	fprintf(fs,"Unique flows found:\t%qu\n", flowstats.ft_entries);
	fprintf(fs,"Total flows  found:\t%qu\n", flowstats.flows);
	fprintf(fs,"Skipped flows found:\t%qu\n", flowstats.skipped_flows);
	fclose(fs);
	return(0);
}
