/*
 *  flow_table.h - Plab
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 *
 */
 
#ifndef H_FLOW_TABLE
#define H_FLOW_TABLE

#define FLOW_TABLE_SIZE 	1572869	/* needs to be a prime number */


struct flow {
	u_quad_t id;
	struct timeval ts_start;		/* timestamp of first pkt */
	struct timeval ts_last;			/* timestamp of last pkt */
	u_long pkts;					/* number of pkts */
	u_quad_t bytes;					/* number of bytes */
	int mss;
	u_quad_t iat;					/* interarrival time wrt the previous flow */
	int skip_flow;					/* skip flow flag */
	int status;						/* keep status of current flow according to fingerprinting */
	struct flow *prev;				/* prev flow (pointer to prev linked list entry) */
};

struct ft_entry {
	u_quad_t	id;					/* Host ID */
	u_char	key[13];				/* key of this entry (dstIP+srcPrt+dstPrt+Prot) */
	u_int	num_flows;				/* number of flow with this key */
	struct flow	*last_flow;			/* pointer to last active flow */
	struct timeval ts_last;			/* timestamp of last pkt */
	struct ft_entry *next;			/* pointer to the next entry w/ different key but same mapping */
};

typedef struct  {
	u_quad_t flows;					/* Total flows processed */
	u_quad_t ft_flows;				/* Flows stored in memory */
	u_quad_t ft_entries;
	u_quad_t skipped_flows;
	struct timeval tv_last_flow;	/* Timestamp of latest flow arrival */
	FILE	*fs_flow_data;			/* File stream to dump flows data */
	FILE	*fs_flow_iat;			/* File stream to dump flows data */
	FILE	*fs_log_ip;				/* File stream to dump IPs */
	FILE	*fs_flow_deleted;

} flow_statistics;

void ft_init_table(struct ft_entry **);
u_long ft_hash(u_char *key);
struct ft_entry *ft_dup_check(u_char *packet, struct ft_entry **flow_table, u_long loc);
struct ft_entry *ft_add_entry(u_char *packet, struct ft_entry **flow_table, u_long loc);
struct ft_entry *ft_get_entry(u_char * packet, struct ft_entry **flow_table);
int delete_flow(struct flow **);
struct flow *flow_init(struct flow *prev, u_char *packet);

#endif
