/*
 *  host_output.c - Plab conversations output routines
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 *
 */

#include <pcap.h>
#include <stdlib.h>
#include <sys/time.h>
#include <time.h>

#include "common.h"
#include "host_table.h"
#include "utils.h"
#include "host_output.h"

extern statistics stats;
extern host_statistics hoststats;
extern program_variables pv;

void ht_display_stats()
{
	if (pv.hosttable) {
		printf("New Hosts found:\t%lu\n", hoststats.ht_entries-hoststats.ht_oldentries);
		printf("Previous Hosts: \t%lu\n\n", hoststats.ht_oldentries);
	} else {
		printf("Total Hosts found:\t%lu\n\n", hoststats.ht_entries);
	}
	printf("Src Hosts found:\t%lu\n", hoststats.ht_src_entries);
	printf("Src Hosts timeout:\t%lu\n", hoststats.ht_src_entries2);
	printf("Dst Hosts found:\t%lu\n", hoststats.ht_dst_entries);
	printf("Dst Hosts timeout:\t%lu\n", hoststats.ht_dst_entries2);	
}


int ht_dump_host_data(struct ht_entry **ht, char *filename)
{
	FILE *fs,*fs2;
	u_long i;
	char path[200];
	char path2[200];
	struct ht_entry *m_entry;

	if (pv.directory) {
		sprintf(path, "%s/%s", pv.directory, filename);
		sprintf(path2, "%s/%s_ip2id", pv.directory, filename);
	} else {
		sprintf(path, "%s", filename);
		sprintf(path2, "%s_ip2id", filename);
	}
		
	fs = fopen(path, "w");
	fs2 = fopen(path2, "w");
	if ((fs == NULL)||(fs2 == NULL)) {
		perror("dump_host_data");
		return(-1);
	}

	for(i = 0; i < HOST_TABLE_SIZE; i++) {
		m_entry = ht[i];
		while (m_entry) {
			fprintf(fs2, "%03d.%03d.%03d.%03d %lu\n",
			    m_entry->key[0],m_entry->key[1],m_entry->key[2],
			    m_entry->key[3], m_entry->id);
			if ((m_entry->pkts_in > 0) || (m_entry->pkts_out > 0)) {
				fprintf(fs, "%lu", m_entry->id);							
				if (m_entry->pkts_out) {
					fprintf(fs, " %qu -1", m_entry->siat);							
				} else if (m_entry->pkts_in) {
					fprintf(fs, " -1 %qu", m_entry->diat);							
				}
				fprintf(fs, " %qu %lu %lu", m_entry->iat, m_entry->pkts_out, m_entry->pkts_in);							
				if (pv.fingerprint) {
					fprintf(fs, " %d\n", (m_entry->count>COUNT_LEV));
				} else {
					fprintf(fs, "\n");
				}
			}
			m_entry = m_entry->next;
		}
	}

	fclose(fs);
	fclose(fs2);
	return(0);
}


int ht_dump_report(FILE *fs)
{
	
	/* Hosts etc. */
	fprintf(fs, "\n");
	if (pv.hosttable) {
		fprintf(fs, "New Hosts found:\t%lu\n", hoststats.ht_entries-hoststats.ht_oldentries);
		fprintf(fs, "Previous Hosts:\t%lu\n\n", hoststats.ht_oldentries);
	} else {
		fprintf(fs, "Total Hosts found:\t%lu\n\n", hoststats.ht_entries);
	}
	fprintf(fs, "Src Hosts found:\t%lu\n", hoststats.ht_src_entries);
	fprintf(fs, "Src Hosts timeout:\t%lu\n", hoststats.ht_src_entries2);
	fprintf(fs, "Dst Hosts found:\t%lu\n", hoststats.ht_dst_entries);
	fprintf(fs, "Dst Hosts timeout:\t%lu\n", hoststats.ht_dst_entries2);	

	fclose(fs);
	return(0);
}
