/*
 *  host_table.h - Plab
 *
 *  Copyright (c) 2004 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

#ifndef H_HOST_TABLE
#define H_HOST_TABLE

#define HOST_TABLE_SIZE		798443	/* 63409 needs to be a prime number */
#define HOST_OUT 0
#define HOST_IN 1

struct ht_entry {
	u_char	key[4];					/* key of this entry (src_ip) */
	u_long	id;
	u_long	mss;					/* */
//	struct timeval ts_start_in;		/* timestamp of first pkt/flow in */
	struct timeval ts_start;		/* timestamp of first pkt/flow out */
	struct timeval ts_last_in;		/* timestamp of last pkt/flow in */
	struct timeval ts_last_out;		/* timestamp of last pkt/flow out*/
	u_quad_t iat;					/* interhost time with previous seen host */
	u_quad_t siat;					/* interhost time with previous seen source host */
	u_quad_t diat;					/* interhost time with previous seen dest host */
	u_long pkts_in;					/* number of in pkts */
	u_long pkts_out;				/* number of out pkts */
	int count;						/* count range -20,20  */
	struct ht_entry *next;			/* pointer to the next entry w/ different key but same mapping */
	struct ht_entry *prev;			/* pointer to the previous entry, same key but when timout is occured */
};

typedef struct  {
	u_long ht_entries;
	u_long ht_oldentries;
	u_long ht_src_entries;
	u_long ht_src_entries2;
	u_long ht_dst_entries;
	u_long ht_dst_entries2;
	struct timeval tv_last_pkt;		/* Timestamp of latest pkt arrived */
	struct timeval tv_last_host;	/* Timestamp of latest host seen */
	struct timeval tv_last_shost;	/* Timestamp of latest source host seen */
	struct timeval tv_last_dhost;	/* Timestamp of latest destination host seen */


	FILE *fs_pkts_all;
#ifdef DEBUG
	FILE *fs_hosts_iat;
#endif

} host_statistics;

void ht_init_table(struct ht_entry **);
u_long ip_hash(u_char *);
struct ht_entry *ht_dup_check(u_char *, struct ht_entry **, u_long);
struct ht_entry *ht_add_entry(u_char * packet, struct ht_entry **table, u_long loc, struct ht_entry *oldentry);
int ht_populate_entry(u_char *hostIP, u_long hostID, struct ht_entry **table);
struct ht_entry *ht_new_entry_src(u_char * packet, struct ht_entry **table, struct ht_entry *oldentry);
struct ht_entry *ht_get_entry_src(u_char *, struct ht_entry **);
struct ht_entry *ht_new_entry_dst(u_char * packet, struct ht_entry **table, struct ht_entry *oldentry);
struct ht_entry *ht_get_entry_dst(u_char *, struct ht_entry **);
int ht_walk_through(struct ht_entry **ht, int (* func)(struct ht_entry *));
struct ht_entry *ht_lookup_entry(u_char *, struct ht_entry **);

#endif

