/*
 *  output.c - Plab
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 *
 */

#include <stdlib.h>
#include <pcap.h>
#include <time.h>
#include <sys/time.h>

#include "common.h"
#include "utils.h"
#include "output.h"

extern program_variables pv;
extern statistics stats;

int dump_pl_distro(u_long d[MAX_PAYLOAD], char *filename)
{
	int i;
	FILE *fs;
	char path[200];

	if (pv.directory)
		sprintf(path, "%s/%s", pv.directory, filename);
	else
		sprintf(path, "%s", filename);

	fs = fopen(path, "w");
	if (fs == NULL) {
		perror("dump_pl_distro");
		return(-1);
	}

	for(i = 0; i < MAX_PAYLOAD; i++) {
		fprintf(fs, "%lu\n", d[i]);
	}

	fclose(fs);

	return(0);
}

FILE *dump_report(int argc, char **argv, char *filename)
{
	int i;
	FILE *fs;
	char path[200];
	/* char command[300];	 just for "ps auxw" */
	struct timeval diff;

	if (pv.directory)
		snprintf(path, 200, "%s/%s", pv.directory, filename);
	else
		snprintf(path, 200, "%s", filename);

	fs = fopen(path, "w");
	if (fs == NULL) {
		perror("dump_report");
		return(NULL);
	}

	/* Command line */
	fprintf(fs, "command line: ");
	for (i = 0; i < argc; i++) {
		fprintf(fs, "%s ", argv[i]);
	}
	fprintf(fs, "\n");

	/* Time */
	fprintf(fs, "\n");
	tvsub(&diff, stats.tv_end, stats.tv_start);
	fprintf(fs, "Time interval of observation: %ld seconds (%ld min - %ld h)\n",
	    diff.tv_sec, diff.tv_sec / 60, diff.tv_sec / 3600);
	fprintf(fs, "First examined packet had timestamp:\t%s", asctime(gmtime(&(stats.tv_start.tv_sec))));
	fprintf(fs, "Last examined packet had timestamp:\t%s", asctime(gmtime(&(stats.tv_end.tv_sec))));
	fprintf(fs, "Packet processing started at:\t\t%s", asctime(gmtime(&(stats.cpu_start))));
	fprintf(fs, "Packet processing finished at:\t\t%s", asctime(gmtime(&(stats.cpu_end))));
	if (stats.interrupted)
		fprintf(fs, "Program execution was INTERRUPTED BY USER (CTRL-C)\n");

	/* Packets */
	fprintf(fs, "\n");
	fprintf(fs, "packets read:\t\t\t\t%qu\n", stats.pkts);
	if (pv.filter_dup) {
		fprintf(fs, "valid packets:\t\t\t\t%qu\n", stats.pkts-stats.bad_pkts-stats.dup_pkts);
		fprintf(fs, "bad packets:\t\t\t\t%qu\n", stats.bad_pkts);
		fprintf(fs, "dup packets:\t\t\t\t%qu\n", stats.dup_pkts);
	}
	fprintf(fs, "mean throughput:\t\t\t%lu pkts/sec\n", (u_long)(stats.pkts / diff.tv_sec));
	fprintf(fs, "\n");
	fprintf(fs, "packets discarded:\t\t\t%qu\n", stats.discarded);
	fprintf(fs, "fragments:\t\t\t\t%qu\n", stats.frags);
	fprintf(fs, "packets were truncated (damaged):\t%qu\n", stats.truncated);
	fprintf(fs, "packets with optional IP headers:\t%qu\n", stats.ip_options);
	fprintf(fs, "packets had invalid tcp payload:\t%qu\n", stats.err_payload);
	fprintf(fs, "packets generated by TCP:\t\t%qu\n", stats.pure_tcp_pkts);
	fprintf(fs, "packets with optional TCP headers:\t%qu\n", stats.tcp_options);
	fprintf(fs, "\n");
	return(fs);
}

void display_stats()
{
	struct timeval diff;

	printf("\n");
	tvsub(&diff, stats.tv_end, stats.tv_start);
	printf("Time interval of observation: %ld seconds (%ld min - %ld h)\n",
	    diff.tv_sec, diff.tv_sec / 60, diff.tv_sec / 3600);
	printf("%qu packets read\n", stats.pkts);
	if (pv.filter_dup) {
		printf("%qu valid packets\n", stats.pkts-stats.bad_pkts-stats.dup_pkts);
		printf("%qu bad packets\n", stats.bad_pkts);
		printf("%qu dup packets\n", stats.dup_pkts);
	}
	printf("mean throughput: %lu pkts/sec\n", (u_long)(stats.pkts / diff.tv_sec));
	printf("\n");
	printf("%qu packets discarded\n", stats.discarded);
	printf("%qu packets were fragments\n", stats.frags);
	printf("%qu packets were truncated (damaged)\n", stats.truncated);
	printf("%qu packets had invalid tcp payload\n", stats.err_payload);
	printf("%qu packets had optional IP headers\n", stats.ip_options);
	printf("%qu packets were generated by TCP\n", stats.pure_tcp_pkts);
	printf("%qu packets had optional TCP headers\n", stats.tcp_options);
	printf("\n");

}

