/*
 *  pkt_macros.h - Plab: macros to work with packets in pcap format
 *
 *  Copyright (c) 2004 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 */

/* 
 * Ethernet (Dec/Intel/Xerox=Eth-II or 802.3)
 */
/* 
 * If the 2-bytes field immediately after eth dst and src address is <= 1500, then
 * the captured frame is of 802.3 type. XXX In the next macros we assume
 * we're always working with Ethernet-II kind of frames, the other standard. So we always need to check before.
 * For an example of how to treat this case see tcpdump/print-ether.c line 112.
 * Anyway, for 802.3 frames we should just add an 8 bytes offset to the numbers below.
 * 
 * For reserved 'type' fields in both ethernet standards see RFC 1340.
 */
#define		PKT_ETH_LEN(a)			((a[12] << 8) + a[13])
#define		PKT_IS_ETH_802(a)		(PKT_ETH_LEN(a) <= 1500)

/*
* ###### Macro function offsets are relative to an IP Packet #####
*/

/*
 * IP Fragments
 */
/* MF bit set */
#define         PKT_MF(a)	 		(a[6] & 0x20)
/* IP fragment offset field */
#define         PKT_FRAG_OFFSET(a)		(a[6] & 0x1f)
/* IP fragment offset in bytes */
#define         PKT_FRAG_OFFSET_B(a)		(PKT_FRAG_OFFSET(a) << 3)
/* pkt is a fragment: if frag_offset != 0 or MF is set */
#define         PKT_IS_FRAGMENT(a)              ((PKT_FRAG_OFFSET(a) != 0) || PKT_MF(a))
/* pkt is the first fragment of an original ip packet */
#define         PKT_FIRST_FRAG(a)	 	(PKT_MF(a) && (PKT_FRAG_OFFSET(a) == 0))
/* pkt is the last fragment of an original ip packet */
#define         PKT_LAST_FRAG(a)	 	((! PKT_MF(a)) && (PKT_FRAG_OFFSET(a) != 0))


#define         PKT_IS_TCP(a)	 		(a[9] == 0x6)
#define         PKT_IS_UDP(a)	 		(a[9] == 0x11)

/*
 * Options
 */
/* pkt has no IP options */
#define         PKT_IS_NO_IP_OPTIONS(a)		(a[0] == 0x45)
/* pkt has IP options */
#define         PKT_IS_IP_OPTIONS(a)            !PKT_IS_NO_IP_OPTIONS(a)
/* pkt has TCP options */
#define         PKT_IS_TCP_OPTIONS(a)           ((a[32] & 0xf0) != 0x50)

/* XXX WARNING: Everything after here doesn't take into account pkts with optional IP header fields */

/*
 * Headers
 */
/* TCP header length in bytes */
#define         PKT_TCP_HLEN_B(a)		((a[32] & 0xf0) >> 2)
/*XXXXXXX TCP header length in bytes */
#define         PKT_TCP_HLEN_B_FIXED(a)		((a[PKT_IP_HLEN_B(a)+14] & 0xf0) >> 2)
/* IP header length in bytes */
#define         PKT_IP_HLEN_B(a)		((a[0] & 0x0f) << 2)
/* IP total length in bytes */
#define         PKT_IP_TLEN_B(a)		((a[2] << 8) + a[3])

/*
 * Payloads
 */
/* IP payload - valid only for non-fragments */
#define		PKT_IP_PAYLOAD_B(a)		(PKT_IP_TLEN_B(a) - PKT_IP_HLEN_B(a))
/* IP payload - valid only if applied to last fragment */
#define		PKT_F_IP_PAYLOAD_B(a)		(PKT_FRAG_OFFSET_B(a) + PKT_IP_TLEN_B(a))
/* TCP payload - valid only for non-fragments */
#define		PKT_TCP_PAYLOAD_B(a)		(PKT_IP_TLEN_B(a) - PKT_IP_HLEN_B(a) - PKT_TCP_HLEN_B(a))
/* UDP payload */
#define		PKT_UDP_PAYLOAD_B(a)		(PKT_IP_TLEN_B(a) - PKT_IP_HLEN_B(a) - 8)
/*
 * Ports
 */
/* TCP source port */
#define         PKT_SRC_PRT(a)		((a[20] << 8) + a[21])
/* TCP destination port */
#define         PKT_DST_PRT(a)		((a[22] << 8) + a[23])

/* 
 * TCP Flags
 */
#define		PKT_TCP_FLAG_FIN(a)		(a[33] & 0x1)
#define		PKT_TCP_FLAG_SYN(a)		(a[33] & 0x2)
#define		PKT_TCP_FLAG_RST(a)		(a[33] & 0x4)
#define		PKT_TCP_FLAG_PSH(a)		(a[33] & 0x8)
#define		PKT_TCP_FLAG_ACK(a)		(a[33] & 0x10)
#define		PKT_TCP_FLAG_URG(a)		(a[33] & 0x20)

/* 
 * Stream direction
 */
#define		PKT_IS_UPSTREAM(a,b)	(PKT_DST_PRT(a) == b)
#define		PKT_IS_DOWNSTREAM(a,b)	(PKT_SRC_PRT(a) == b)


