/*
 *  plab.h
 *
 *  Copyright (c) 2004-2006 Alberto Dainotti, Antonio Pescape', Alessio Botta
 *  Email: alberto@unina.it , pescape@unina.it , a.botta@unina.it
 *  DIS - Dipartimento di Informatica e Sistemistica (Computer Science Department)
 *  University of Naples Federico II
 *  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * Student contributors: Alessandro de Peppo (depeppo@unina.it)
 *
 */

#ifndef H_PLAB
#define H_PLAB

#define _FILE_OFFSET_BITS 64
#define PROMISC         	1
#define DEFAULT_SNAPLEN		1514
#define TIMEOUT         	5


#define TICK(ts, sec)		(ts - (ts % sec))	/* find the nearest previous tick, with a resolution of sec */

extern char *optarg;			/* for getopt */
extern int   optind;			/* for getopt */



/*
 * Function prototypes
 */
void parse_command_line(int, char **);
int init_program();
int init_host_table();
void distro_pl_init(u_long distro[MAX_PAYLOAD]);
int fingerprint(u_char *packet);
int ht_process_packet(u_char *, const struct pcap_pkthdr);
int ft_process_packet(u_char *, const struct pcap_pkthdr);
int ct_process_packet(u_char *, const struct pcap_pkthdr);
void cleanup(int);
void parse_command_line(int, char **);
int filter_packet(u_char *, const struct pcap_pkthdr);
int rate(const struct pcap_pkthdr, int);
void rate_init();
int detect_mss(u_char *, const struct pcap_pkthdr);
char * read_infile(char *);
void next_file_name(struct pcap_pkthdr *);
int splitter(pcap_t *);
void print_help();
#endif

/* EOF */
